/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.devtools;

import java.util.Arrays;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ExpressionsBundleGenerator {
    private ExpressionsBundleGenerator() {
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        ExpressionMetaData[] datas = ExpressionRegistry.getInstance().getAllExpressionMetaDatas();
        Arrays.sort(datas, GroupedMetaDataComparator.ENGLISH);
        for (int i = 0; i < datas.length; ++i) {
            ExpressionMetaData data = datas[i];
            if (!(data instanceof AbstractMetaData)) continue;
            ExpressionsBundleGenerator.printMetaBundle(data);
        }
    }

    private static void printMetaBundle(ExpressionMetaData type) {
        System.out.println("# -----------------------------------------------------");
        System.out.println("# " + ExpressionsBundleGenerator.printBundleLocation(type));
        System.out.println("# -----------------------------------------------------");
        String prefix = ExpressionsBundleGenerator.calculatePrefix(type);
        ExpressionsBundleGenerator.printMetadata(type, prefix, "display-name", type.getName());
        ExpressionsBundleGenerator.printMetadata(type, prefix, "grouping", "");
        ExpressionsBundleGenerator.printMetadata(type, prefix, "grouping.ordinal", "0");
        ExpressionsBundleGenerator.printMetadata(type, prefix, "ordinal", "0");
        ExpressionsBundleGenerator.printMetadata(type, prefix, "description", "");
        ExpressionsBundleGenerator.printMetadata(type, prefix, "deprecated", "");
        ExpressionsBundleGenerator.printMetadata(type, prefix, "icon", "");
        System.out.println();
        ExpressionPropertyMetaData[] attributes = type.getPropertyDescriptions();
        Arrays.sort(attributes, GroupedMetaDataComparator.ENGLISH);
        for (int j = 0; j < attributes.length; ++j) {
            ExpressionPropertyMetaData attribute = attributes[j];
            String propertyPrefix = ExpressionsBundleGenerator.calculatePrefix(attribute);
            ExpressionsBundleGenerator.printMetadata(attribute, propertyPrefix, "display-name", attribute.getName());
            ExpressionsBundleGenerator.printMetadata(attribute, propertyPrefix, "grouping", "");
            ExpressionsBundleGenerator.printMetadata(attribute, propertyPrefix, "grouping.ordinal", "0");
            ExpressionsBundleGenerator.printMetadata(attribute, propertyPrefix, "ordinal", "0");
            ExpressionsBundleGenerator.printMetadata(attribute, propertyPrefix, "description", "");
            ExpressionsBundleGenerator.printMetadata(attribute, propertyPrefix, "deprecated", "");
            System.out.println();
        }
        System.out.println("-----------------------------------------------------");
    }

    private static String calculatePrefix(MetaData type) {
        AbstractMetaData metaData;
        String prefixMetadata;
        String prefix = type instanceof AbstractMetaData ? (StringUtils.isEmpty((String)(prefixMetadata = (metaData = (AbstractMetaData)type).getKeyPrefix())) ? "" : prefixMetadata + type.getName() + ".") : "";
        return prefix;
    }

    private static String readMetadataAttribute(MetaData metaData, String name, String defaultValue) {
        String metaAttribute = metaData.getMetaAttribute(name, Locale.ENGLISH);
        if (metaAttribute == null) {
            return defaultValue;
        }
        return metaAttribute;
    }

    private static void printMetadata(MetaData metaData, String prefix, String name, String defaultValue) {
        System.out.println(prefix + name + "=" + ExpressionsBundleGenerator.readMetadataAttribute(metaData, name, defaultValue));
    }

    private static String printBundleLocation(ExpressionMetaData metaData) {
        if (metaData instanceof AbstractMetaData) {
            AbstractMetaData metaDataImpl = (AbstractMetaData)((Object)metaData);
            return metaDataImpl.getBundleLocation().replace('.', '/') + ".properties";
        }
        return metaData.getExpressionType().getCanonicalName().replace('.', '/') + "Bundle.properties";
    }
}

