/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.function.ColumnAggregationExpression;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;

public class SingleValueQueryFunction
extends ColumnAggregationExpression {
    private static final Log logger = LogFactory.getLog(SingleValueQueryFunction.class);
    private String query;
    private String resultColumn;
    private int queryTimeout;

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public String getResultColumn() {
        return this.resultColumn;
    }

    public void setResultColumn(String resultColumn) {
        this.resultColumn = resultColumn;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private Object performQuery() {
        if (this.query == null) {
            return null;
        }
        try {
            DataFactory dataFactory = this.getRuntime().getDataFactory();
            String[] fields = this.getField();
            int length = fields.length;
            ParameterMapping[] mappings = new ParameterMapping[length];
            for (int i = 0; i < length; ++i) {
                mappings[i] = new ParameterMapping(fields[i], fields[i]);
            }
            QueryParametersDataRow params = new QueryParametersDataRow(this.getDataRow(), mappings);
            TableModel tableModel = dataFactory.queryData(this.query, new QueryDataRowWrapper((DataRow)params, 1, this.queryTimeout));
            if (tableModel == null) {
                return null;
            }
            int columnCount = tableModel.getColumnCount();
            if (tableModel.getRowCount() == 0 || columnCount == 0) {
                return null;
            }
            if (this.resultColumn == null) {
                return tableModel.getValueAt(0, 0);
            }
            for (int i = 0; i < columnCount; ++i) {
                if (!this.resultColumn.equals(tableModel.getColumnName(i))) continue;
                return tableModel.getValueAt(0, i);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"SingleValueQueryFunction: Failed to perform query", (Throwable)e);
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.performQuery();
    }

    private static class QueryParametersDataRow
    extends StaticDataRow {
        private QueryParametersDataRow(DataRow globalView, ParameterMapping[] parameterMappings) {
            String[] outerNames = new String[parameterMappings.length];
            Object[] values = new Object[parameterMappings.length];
            for (int i = 0; i < parameterMappings.length; ++i) {
                ParameterMapping mapping = parameterMappings[i];
                String name = mapping.getAlias();
                values[i] = globalView.get(name);
                outerNames[i] = mapping.getName();
            }
            this.setData(outerNames, values);
        }
    }
}

