/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.osgi.platform.plugin.deployer.api.ManifestUpdater;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.pentaho.osgi.platform.plugin.deployer.impl.ManifestUpdaterImpl;
import org.w3c.dom.Document;

public class PluginMetadataImpl
implements PluginMetadata {
    private final ManifestUpdater manifestUpdater = new ManifestUpdaterImpl();
    private final Document blueprint = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    private final File rootDirectory;

    public PluginMetadataImpl(File rootDirectory) throws ParserConfigurationException {
        this.blueprint.appendChild(this.blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "blueprint"));
        this.rootDirectory = rootDirectory;
    }

    @Override
    public ManifestUpdater getManifestUpdater() {
        return this.manifestUpdater;
    }

    @Override
    public Document getBlueprint() {
        return this.blueprint;
    }

    @Override
    public void writeBlueprint(OutputStream outputStream) throws IOException {
        StreamResult output = new StreamResult(outputStream);
        DOMSource input = new DOMSource(this.getBlueprint());
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public FileWriter getFileWriter(String path) throws IOException {
        File resultFile = new File(this.rootDirectory.getAbsolutePath() + "/" + path);
        File parentDir = resultFile.getParentFile();
        int tries = 100;
        while (!parentDir.exists() && tries-- > 0) {
            parentDir.mkdirs();
        }
        return new FileWriter(resultFile);
    }
}

