/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.di.plugin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPluginCategories;
import org.pentaho.di.ui.spoon.SpoonPluginInterface;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.marketplace.di.plugin.MenuHandler;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.impl.XulEventHandler;

@org.pentaho.di.ui.spoon.SpoonPlugin(id="pentaho-marketplace-di", image="")
@SpoonPluginCategories(value={"spoon"})
public class SpoonPlugin
implements SpoonPluginInterface {
    private static final String RESOURCE_PATH = "org/pentaho/marketplace/di/plugin/res";
    private static final String OVERLAY_FILE_PATH = "org/pentaho/marketplace/di/plugin/res/spoon_overlay.xul";
    private static final String SPOON_CATEGORY = "spoon";
    private XulDomContainer container;
    private Spoon spoon;
    private Log logger = LogFactory.getLog(this.getClass());
    private MenuHandler menuHandler;

    public SpoonLifecycleListener getLifecycleListener() {
        return new SpoonLifecycleListener(){

            public void onEvent(SpoonLifecycleListener.SpoonLifeCycleEvent evt) {
                if (evt.equals((Object)SpoonLifecycleListener.SpoonLifeCycleEvent.STARTUP)) {
                    try {
                        SpoonPlugin.this.getSpoon().setMarketMethod(MenuHandler.class.getMethod("openMarketplace", new Class[0]));
                    }
                    catch (Throwable e) {
                        SpoonPlugin.this.logger.warn((Object)e.getMessage(), e);
                    }
                }
            }
        };
    }

    public SpoonPerspective getPerspective() {
        return null;
    }

    public Spoon getSpoon() {
        if (this.spoon == null) {
            return Spoon.getInstance();
        }
        return this.spoon;
    }

    public void setSpoon(Spoon spoon) {
        this.spoon = spoon;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected MenuHandler getMenuHandler() {
        return this.menuHandler;
    }

    protected void setMenuHandler(MenuHandler menuHandler) {
        this.menuHandler = menuHandler;
    }

    public SpoonPlugin() {
        this.setMenuHandler(new MenuHandler());
    }

    public void applyToContainer(String category, XulDomContainer container) throws XulException {
        if (category.equals(SPOON_CATEGORY)) {
            this.container = container;
            container.registerClassLoader((Object)this.getClass().getClassLoader());
            container.loadOverlay(OVERLAY_FILE_PATH);
            container.addEventHandler((XulEventHandler)this.getMenuHandler());
            this.getSpoon().enableMenus();
        }
    }

    public void removeFromContainer() throws XulException {
        if (this.container == null) {
            return;
        }
        final Spoon spoon = this.getSpoon();
        final Log logger = this.getLogger();
        final String menuHandlerName = this.getMenuHandler().getName();
        spoon.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    SpoonPlugin.this.container.removeOverlay(SpoonPlugin.OVERLAY_FILE_PATH);
                }
                catch (XulException e) {
                    logger.error((Object)"Error removing overlay: org/pentaho/marketplace/di/plugin/res/spoon_overlay.xul", (Throwable)e);
                }
                SpoonPlugin.this.container.getEventHandlers().remove(menuHandlerName);
                SpoonPlugin.this.container.deRegisterClassLoader((Object)SpoonPlugin.class.getClassLoader());
                this.closeMarketplaceTab();
                spoon.enableMenus();
            }

            private void closeMarketplaceTab() {
                TabMapEntry marketplaceTab = this.getMarketplaceTab();
                if (marketplaceTab != null) {
                    spoon.delegates.tabs.removeTab(marketplaceTab);
                }
            }

            private TabMapEntry getMarketplaceTab() {
                TabMapEntry marketplaceTab = null;
                for (TabMapEntry tabMapEntry : spoon.delegates.tabs.getTabs()) {
                    if (!tabMapEntry.getTabItem().getId().equalsIgnoreCase("Marketplace")) continue;
                    marketplaceTab = tabMapEntry;
                    break;
                }
                return marketplaceTab;
            }
        });
    }
}

