/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.autoscaling.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {
    @Override
    public Request<PutNotificationConfigurationRequest> marshall(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        if (putNotificationConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutNotificationConfigurationRequest> request = new DefaultRequest<PutNotificationConfigurationRequest>(putNotificationConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        if (putNotificationConfigurationRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(putNotificationConfigurationRequest.getAutoScalingGroupName()));
        }
        if (putNotificationConfigurationRequest.getTopicARN() != null) {
            request.addParameter("TopicARN", StringUtils.fromString(putNotificationConfigurationRequest.getTopicARN()));
        }
        List<String> notificationTypesList = putNotificationConfigurationRequest.getNotificationTypes();
        int notificationTypesListIndex = 1;
        for (String notificationTypesListValue : notificationTypesList) {
            if (notificationTypesListValue != null) {
                request.addParameter("NotificationTypes.member." + notificationTypesListIndex, StringUtils.fromString(notificationTypesListValue));
            }
            ++notificationTypesListIndex;
        }
        return request;
    }
}

