/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudfront.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.cloudfront.model.GeoRestrictionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoRestriction
implements Serializable {
    private String restrictionType;
    private Integer quantity;
    private ListWithAutoConstructFlag<String> items;

    public GeoRestriction() {
    }

    public GeoRestriction(String restrictionType) {
        this.setRestrictionType(restrictionType);
    }

    public GeoRestriction(GeoRestrictionType restrictionType) {
        this.restrictionType = restrictionType.toString();
    }

    public String getRestrictionType() {
        return this.restrictionType;
    }

    public void setRestrictionType(String restrictionType) {
        this.restrictionType = restrictionType;
    }

    public GeoRestriction withRestrictionType(String restrictionType) {
        this.restrictionType = restrictionType;
        return this;
    }

    public void setRestrictionType(GeoRestrictionType restrictionType) {
        this.restrictionType = restrictionType.toString();
    }

    public GeoRestriction withRestrictionType(GeoRestrictionType restrictionType) {
        this.restrictionType = restrictionType.toString();
        return this;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public GeoRestriction withQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new ListWithAutoConstructFlag();
            this.items.setAutoConstruct(true);
        }
        return this.items;
    }

    public void setItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public GeoRestriction withItems(String ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<String>(items.length));
        }
        for (String value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public GeoRestriction withItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRestrictionType() != null) {
            sb.append("RestrictionType: " + this.getRestrictionType() + ",");
        }
        if (this.getQuantity() != null) {
            sb.append("Quantity: " + this.getQuantity() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRestrictionType() == null ? 0 : this.getRestrictionType().hashCode());
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoRestriction)) {
            return false;
        }
        GeoRestriction other = (GeoRestriction)obj;
        if (other.getRestrictionType() == null ^ this.getRestrictionType() == null) {
            return false;
        }
        if (other.getRestrictionType() != null && !other.getRestrictionType().equals(this.getRestrictionType())) {
            return false;
        }
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }
}

