/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudsearch.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeRankExpressionsRequestMarshaller
implements Marshaller<Request<DescribeRankExpressionsRequest>, DescribeRankExpressionsRequest> {
    @Override
    public Request<DescribeRankExpressionsRequest> marshall(DescribeRankExpressionsRequest describeRankExpressionsRequest) {
        if (describeRankExpressionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRankExpressionsRequest> request = new DefaultRequest<DescribeRankExpressionsRequest>(describeRankExpressionsRequest, "AmazonCloudSearch");
        request.addParameter("Action", "DescribeRankExpressions");
        request.addParameter("Version", "2011-02-01");
        if (describeRankExpressionsRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(describeRankExpressionsRequest.getDomainName()));
        }
        List<String> rankNamesList = describeRankExpressionsRequest.getRankNames();
        int rankNamesListIndex = 1;
        for (String rankNamesListValue : rankNamesList) {
            if (rankNamesListValue != null) {
                request.addParameter("RankNames.member." + rankNamesListIndex, StringUtils.fromString(rankNamesListValue));
            }
            ++rankNamesListIndex;
        }
        return request;
    }
}

