/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.directconnect;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.AsyncHandler;
import com.cloudera.com.amazonaws.services.directconnect.AmazonDirectConnectAsync;
import com.cloudera.com.amazonaws.services.directconnect.AmazonDirectConnectClient;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmConnectionRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmConnectionResult;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateConnectionResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteConnectionRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteConnectionResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeInterconnectsResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeLocationsRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeLocationsResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonDirectConnectAsyncClient
extends AmazonDirectConnectClient
implements AmazonDirectConnectAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonDirectConnectAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonDirectConnectAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDirectConnectAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonDirectConnectAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonDirectConnectAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeLocationsResult> describeLocationsAsync(final DescribeLocationsRequest describeLocationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLocationsResult>(){

            @Override
            public DescribeLocationsResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.describeLocations(describeLocationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeLocationsResult> describeLocationsAsync(final DescribeLocationsRequest describeLocationsRequest, final AsyncHandler<DescribeLocationsRequest, DescribeLocationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLocationsResult>(){

            @Override
            public DescribeLocationsResult call() throws Exception {
                DescribeLocationsResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeLocations(describeLocationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeLocationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmPublicVirtualInterfaceResult> confirmPublicVirtualInterfaceAsync(final ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmPublicVirtualInterfaceResult>(){

            @Override
            public ConfirmPublicVirtualInterfaceResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.confirmPublicVirtualInterface(confirmPublicVirtualInterfaceRequest);
            }
        });
    }

    @Override
    public Future<ConfirmPublicVirtualInterfaceResult> confirmPublicVirtualInterfaceAsync(final ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest, final AsyncHandler<ConfirmPublicVirtualInterfaceRequest, ConfirmPublicVirtualInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmPublicVirtualInterfaceResult>(){

            @Override
            public ConfirmPublicVirtualInterfaceResult call() throws Exception {
                ConfirmPublicVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.confirmPublicVirtualInterface(confirmPublicVirtualInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(confirmPublicVirtualInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePrivateVirtualInterfaceResult> createPrivateVirtualInterfaceAsync(final CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePrivateVirtualInterfaceResult>(){

            @Override
            public CreatePrivateVirtualInterfaceResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.createPrivateVirtualInterface(createPrivateVirtualInterfaceRequest);
            }
        });
    }

    @Override
    public Future<CreatePrivateVirtualInterfaceResult> createPrivateVirtualInterfaceAsync(final CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest, final AsyncHandler<CreatePrivateVirtualInterfaceRequest, CreatePrivateVirtualInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePrivateVirtualInterfaceResult>(){

            @Override
            public CreatePrivateVirtualInterfaceResult call() throws Exception {
                CreatePrivateVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createPrivateVirtualInterface(createPrivateVirtualInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPrivateVirtualInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVirtualInterfaceResult> deleteVirtualInterfaceAsync(final DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteVirtualInterfaceResult>(){

            @Override
            public DeleteVirtualInterfaceResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.deleteVirtualInterface(deleteVirtualInterfaceRequest);
            }
        });
    }

    @Override
    public Future<DeleteVirtualInterfaceResult> deleteVirtualInterfaceAsync(final DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest, final AsyncHandler<DeleteVirtualInterfaceRequest, DeleteVirtualInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteVirtualInterfaceResult>(){

            @Override
            public DeleteVirtualInterfaceResult call() throws Exception {
                DeleteVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.deleteVirtualInterface(deleteVirtualInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVirtualInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePublicVirtualInterfaceResult> createPublicVirtualInterfaceAsync(final CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePublicVirtualInterfaceResult>(){

            @Override
            public CreatePublicVirtualInterfaceResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.createPublicVirtualInterface(createPublicVirtualInterfaceRequest);
            }
        });
    }

    @Override
    public Future<CreatePublicVirtualInterfaceResult> createPublicVirtualInterfaceAsync(final CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest, final AsyncHandler<CreatePublicVirtualInterfaceRequest, CreatePublicVirtualInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePublicVirtualInterfaceResult>(){

            @Override
            public CreatePublicVirtualInterfaceResult call() throws Exception {
                CreatePublicVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createPublicVirtualInterface(createPublicVirtualInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPublicVirtualInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateInterconnectResult> createInterconnectAsync(final CreateInterconnectRequest createInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInterconnectResult>(){

            @Override
            public CreateInterconnectResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.createInterconnect(createInterconnectRequest);
            }
        });
    }

    @Override
    public Future<CreateInterconnectResult> createInterconnectAsync(final CreateInterconnectRequest createInterconnectRequest, final AsyncHandler<CreateInterconnectRequest, CreateInterconnectResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInterconnectResult>(){

            @Override
            public CreateInterconnectResult call() throws Exception {
                CreateInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createInterconnect(createInterconnectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createInterconnectRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualInterfacesResult> describeVirtualInterfacesAsync(final DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVirtualInterfacesResult>(){

            @Override
            public DescribeVirtualInterfacesResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.describeVirtualInterfaces(describeVirtualInterfacesRequest);
            }
        });
    }

    @Override
    public Future<DescribeVirtualInterfacesResult> describeVirtualInterfacesAsync(final DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest, final AsyncHandler<DescribeVirtualInterfacesRequest, DescribeVirtualInterfacesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVirtualInterfacesResult>(){

            @Override
            public DescribeVirtualInterfacesResult call() throws Exception {
                DescribeVirtualInterfacesResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeVirtualInterfaces(describeVirtualInterfacesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVirtualInterfacesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmConnectionResult> confirmConnectionAsync(final ConfirmConnectionRequest confirmConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmConnectionResult>(){

            @Override
            public ConfirmConnectionResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.confirmConnection(confirmConnectionRequest);
            }
        });
    }

    @Override
    public Future<ConfirmConnectionResult> confirmConnectionAsync(final ConfirmConnectionRequest confirmConnectionRequest, final AsyncHandler<ConfirmConnectionRequest, ConfirmConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmConnectionResult>(){

            @Override
            public ConfirmConnectionResult call() throws Exception {
                ConfirmConnectionResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.confirmConnection(confirmConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(confirmConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInterconnectsResult> describeInterconnectsAsync(final DescribeInterconnectsRequest describeInterconnectsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInterconnectsResult>(){

            @Override
            public DescribeInterconnectsResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.describeInterconnects(describeInterconnectsRequest);
            }
        });
    }

    @Override
    public Future<DescribeInterconnectsResult> describeInterconnectsAsync(final DescribeInterconnectsRequest describeInterconnectsRequest, final AsyncHandler<DescribeInterconnectsRequest, DescribeInterconnectsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInterconnectsResult>(){

            @Override
            public DescribeInterconnectsResult call() throws Exception {
                DescribeInterconnectsResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeInterconnects(describeInterconnectsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeInterconnectsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualGatewaysResult> describeVirtualGatewaysAsync(final DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVirtualGatewaysResult>(){

            @Override
            public DescribeVirtualGatewaysResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.describeVirtualGateways(describeVirtualGatewaysRequest);
            }
        });
    }

    @Override
    public Future<DescribeVirtualGatewaysResult> describeVirtualGatewaysAsync(final DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest, final AsyncHandler<DescribeVirtualGatewaysRequest, DescribeVirtualGatewaysResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVirtualGatewaysResult>(){

            @Override
            public DescribeVirtualGatewaysResult call() throws Exception {
                DescribeVirtualGatewaysResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeVirtualGateways(describeVirtualGatewaysRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVirtualGatewaysRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmPrivateVirtualInterfaceResult> confirmPrivateVirtualInterfaceAsync(final ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmPrivateVirtualInterfaceResult>(){

            @Override
            public ConfirmPrivateVirtualInterfaceResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.confirmPrivateVirtualInterface(confirmPrivateVirtualInterfaceRequest);
            }
        });
    }

    @Override
    public Future<ConfirmPrivateVirtualInterfaceResult> confirmPrivateVirtualInterfaceAsync(final ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest, final AsyncHandler<ConfirmPrivateVirtualInterfaceRequest, ConfirmPrivateVirtualInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmPrivateVirtualInterfaceResult>(){

            @Override
            public ConfirmPrivateVirtualInterfaceResult call() throws Exception {
                ConfirmPrivateVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.confirmPrivateVirtualInterface(confirmPrivateVirtualInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(confirmPrivateVirtualInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectionsResult> describeConnectionsAsync(final DescribeConnectionsRequest describeConnectionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConnectionsResult>(){

            @Override
            public DescribeConnectionsResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.describeConnections(describeConnectionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeConnectionsResult> describeConnectionsAsync(final DescribeConnectionsRequest describeConnectionsRequest, final AsyncHandler<DescribeConnectionsRequest, DescribeConnectionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConnectionsResult>(){

            @Override
            public DescribeConnectionsResult call() throws Exception {
                DescribeConnectionsResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeConnections(describeConnectionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeConnectionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AllocatePublicVirtualInterfaceResult> allocatePublicVirtualInterfaceAsync(final AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocatePublicVirtualInterfaceResult>(){

            @Override
            public AllocatePublicVirtualInterfaceResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.allocatePublicVirtualInterface(allocatePublicVirtualInterfaceRequest);
            }
        });
    }

    @Override
    public Future<AllocatePublicVirtualInterfaceResult> allocatePublicVirtualInterfaceAsync(final AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest, final AsyncHandler<AllocatePublicVirtualInterfaceRequest, AllocatePublicVirtualInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocatePublicVirtualInterfaceResult>(){

            @Override
            public AllocatePublicVirtualInterfaceResult call() throws Exception {
                AllocatePublicVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.allocatePublicVirtualInterface(allocatePublicVirtualInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(allocatePublicVirtualInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AllocatePrivateVirtualInterfaceResult> allocatePrivateVirtualInterfaceAsync(final AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocatePrivateVirtualInterfaceResult>(){

            @Override
            public AllocatePrivateVirtualInterfaceResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.allocatePrivateVirtualInterface(allocatePrivateVirtualInterfaceRequest);
            }
        });
    }

    @Override
    public Future<AllocatePrivateVirtualInterfaceResult> allocatePrivateVirtualInterfaceAsync(final AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest, final AsyncHandler<AllocatePrivateVirtualInterfaceRequest, AllocatePrivateVirtualInterfaceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocatePrivateVirtualInterfaceResult>(){

            @Override
            public AllocatePrivateVirtualInterfaceResult call() throws Exception {
                AllocatePrivateVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.allocatePrivateVirtualInterface(allocatePrivateVirtualInterfaceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(allocatePrivateVirtualInterfaceRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(final DeleteConnectionRequest deleteConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteConnectionResult>(){

            @Override
            public DeleteConnectionResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.deleteConnection(deleteConnectionRequest);
            }
        });
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(final DeleteConnectionRequest deleteConnectionRequest, final AsyncHandler<DeleteConnectionRequest, DeleteConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteConnectionResult>(){

            @Override
            public DeleteConnectionResult call() throws Exception {
                DeleteConnectionResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.deleteConnection(deleteConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectionsOnInterconnectResult> describeConnectionsOnInterconnectAsync(final DescribeConnectionsOnInterconnectRequest describeConnectionsOnInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConnectionsOnInterconnectResult>(){

            @Override
            public DescribeConnectionsOnInterconnectResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.describeConnectionsOnInterconnect(describeConnectionsOnInterconnectRequest);
            }
        });
    }

    @Override
    public Future<DescribeConnectionsOnInterconnectResult> describeConnectionsOnInterconnectAsync(final DescribeConnectionsOnInterconnectRequest describeConnectionsOnInterconnectRequest, final AsyncHandler<DescribeConnectionsOnInterconnectRequest, DescribeConnectionsOnInterconnectResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConnectionsOnInterconnectResult>(){

            @Override
            public DescribeConnectionsOnInterconnectResult call() throws Exception {
                DescribeConnectionsOnInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeConnectionsOnInterconnect(describeConnectionsOnInterconnectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeConnectionsOnInterconnectRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AllocateConnectionOnInterconnectResult> allocateConnectionOnInterconnectAsync(final AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocateConnectionOnInterconnectResult>(){

            @Override
            public AllocateConnectionOnInterconnectResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.allocateConnectionOnInterconnect(allocateConnectionOnInterconnectRequest);
            }
        });
    }

    @Override
    public Future<AllocateConnectionOnInterconnectResult> allocateConnectionOnInterconnectAsync(final AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest, final AsyncHandler<AllocateConnectionOnInterconnectRequest, AllocateConnectionOnInterconnectResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocateConnectionOnInterconnectResult>(){

            @Override
            public AllocateConnectionOnInterconnectResult call() throws Exception {
                AllocateConnectionOnInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.allocateConnectionOnInterconnect(allocateConnectionOnInterconnectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(allocateConnectionOnInterconnectRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(final CreateConnectionRequest createConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateConnectionResult>(){

            @Override
            public CreateConnectionResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.createConnection(createConnectionRequest);
            }
        });
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(final CreateConnectionRequest createConnectionRequest, final AsyncHandler<CreateConnectionRequest, CreateConnectionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateConnectionResult>(){

            @Override
            public CreateConnectionResult call() throws Exception {
                CreateConnectionResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createConnection(createConnectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createConnectionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInterconnectResult> deleteInterconnectAsync(final DeleteInterconnectRequest deleteInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteInterconnectResult>(){

            @Override
            public DeleteInterconnectResult call() throws Exception {
                return AmazonDirectConnectAsyncClient.this.deleteInterconnect(deleteInterconnectRequest);
            }
        });
    }

    @Override
    public Future<DeleteInterconnectResult> deleteInterconnectAsync(final DeleteInterconnectRequest deleteInterconnectRequest, final AsyncHandler<DeleteInterconnectRequest, DeleteInterconnectResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteInterconnectResult>(){

            @Override
            public DeleteInterconnectResult call() throws Exception {
                DeleteInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.deleteInterconnect(deleteInterconnectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteInterconnectRequest, result);
                return result;
            }
        });
    }
}

