/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.cloudera.com.amazonaws.services.ec2.model.Filter;
import com.cloudera.com.amazonaws.services.ec2.model.transform.DescribeCustomerGatewaysRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeCustomerGatewaysRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeCustomerGatewaysRequest> {
    private ListWithAutoConstructFlag<String> customerGatewayIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getCustomerGatewayIds() {
        if (this.customerGatewayIds == null) {
            this.customerGatewayIds = new ListWithAutoConstructFlag();
            this.customerGatewayIds.setAutoConstruct(true);
        }
        return this.customerGatewayIds;
    }

    public void setCustomerGatewayIds(Collection<String> customerGatewayIds) {
        if (customerGatewayIds == null) {
            this.customerGatewayIds = null;
            return;
        }
        ListWithAutoConstructFlag customerGatewayIdsCopy = new ListWithAutoConstructFlag(customerGatewayIds.size());
        customerGatewayIdsCopy.addAll(customerGatewayIds);
        this.customerGatewayIds = customerGatewayIdsCopy;
    }

    public DescribeCustomerGatewaysRequest withCustomerGatewayIds(String ... customerGatewayIds) {
        if (this.getCustomerGatewayIds() == null) {
            this.setCustomerGatewayIds(new ArrayList<String>(customerGatewayIds.length));
        }
        for (String value : customerGatewayIds) {
            this.getCustomerGatewayIds().add(value);
        }
        return this;
    }

    public DescribeCustomerGatewaysRequest withCustomerGatewayIds(Collection<String> customerGatewayIds) {
        if (customerGatewayIds == null) {
            this.customerGatewayIds = null;
        } else {
            ListWithAutoConstructFlag customerGatewayIdsCopy = new ListWithAutoConstructFlag(customerGatewayIds.size());
            customerGatewayIdsCopy.addAll(customerGatewayIds);
            this.customerGatewayIds = customerGatewayIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeCustomerGatewaysRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeCustomerGatewaysRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeCustomerGatewaysRequest> getDryRunRequest() {
        Request<DescribeCustomerGatewaysRequest> request = new DescribeCustomerGatewaysRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomerGatewayIds() != null) {
            sb.append("CustomerGatewayIds: " + this.getCustomerGatewayIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomerGatewayIds() == null ? 0 : this.getCustomerGatewayIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysRequest)) {
            return false;
        }
        DescribeCustomerGatewaysRequest other = (DescribeCustomerGatewaysRequest)obj;
        if (other.getCustomerGatewayIds() == null ^ this.getCustomerGatewayIds() == null) {
            return false;
        }
        if (other.getCustomerGatewayIds() != null && !other.getCustomerGatewayIds().equals(this.getCustomerGatewayIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }
}

