/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.cloudera.com.amazonaws.services.ec2.model.transform.ImportKeyPairRequestMarshaller;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportKeyPairRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<ImportKeyPairRequest> {
    private String keyName;
    private String publicKeyMaterial;

    public ImportKeyPairRequest() {
    }

    public ImportKeyPairRequest(String keyName, String publicKeyMaterial) {
        this.setKeyName(keyName);
        this.setPublicKeyMaterial(publicKeyMaterial);
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public ImportKeyPairRequest withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String getPublicKeyMaterial() {
        return this.publicKeyMaterial;
    }

    public void setPublicKeyMaterial(String publicKeyMaterial) {
        this.publicKeyMaterial = publicKeyMaterial;
    }

    public ImportKeyPairRequest withPublicKeyMaterial(String publicKeyMaterial) {
        this.publicKeyMaterial = publicKeyMaterial;
        return this;
    }

    @Override
    public Request<ImportKeyPairRequest> getDryRunRequest() {
        Request<ImportKeyPairRequest> request = new ImportKeyPairRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyName() != null) {
            sb.append("KeyName: " + this.getKeyName() + ",");
        }
        if (this.getPublicKeyMaterial() != null) {
            sb.append("PublicKeyMaterial: " + this.getPublicKeyMaterial());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getPublicKeyMaterial() == null ? 0 : this.getPublicKeyMaterial().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest)obj;
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getPublicKeyMaterial() == null ^ this.getPublicKeyMaterial() == null) {
            return false;
        }
        return other.getPublicKeyMaterial() == null || other.getPublicKeyMaterial().equals(this.getPublicKeyMaterial());
    }
}

