/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.ec2.model.ImportKeyPairRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportKeyPairRequestMarshaller
implements Marshaller<Request<ImportKeyPairRequest>, ImportKeyPairRequest> {
    @Override
    public Request<ImportKeyPairRequest> marshall(ImportKeyPairRequest importKeyPairRequest) {
        if (importKeyPairRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportKeyPairRequest> request = new DefaultRequest<ImportKeyPairRequest>(importKeyPairRequest, "AmazonEC2");
        request.addParameter("Action", "ImportKeyPair");
        request.addParameter("Version", "2013-10-15");
        if (importKeyPairRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(importKeyPairRequest.getKeyName()));
        }
        if (importKeyPairRequest.getPublicKeyMaterial() != null) {
            request.addParameter("PublicKeyMaterial", StringUtils.fromString(importKeyPairRequest.getPublicKeyMaterial()));
        }
        return request;
    }
}

