/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticloadbalancing.model.transform;

import com.cloudera.com.amazonaws.services.elasticloadbalancing.model.PolicyDescription;
import com.cloudera.com.amazonaws.services.elasticloadbalancing.model.transform.PolicyAttributeDescriptionStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyDescriptionStaxUnmarshaller
implements Unmarshaller<PolicyDescription, StaxUnmarshallerContext> {
    private static PolicyDescriptionStaxUnmarshaller instance;

    @Override
    public PolicyDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        PolicyDescription policyDescription = new PolicyDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return policyDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PolicyName", targetDepth)) {
                    policyDescription.setPolicyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyTypeName", targetDepth)) {
                    policyDescription.setPolicyTypeName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PolicyAttributeDescriptions/member", targetDepth)) continue;
                policyDescription.getPolicyAttributeDescriptions().add(PolicyAttributeDescriptionStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return policyDescription;
    }

    public static PolicyDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PolicyDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

