/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.glacier.model.transform;

import com.cloudera.com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.cloudera.com.amazonaws.transform.JsonUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import com.cloudera.com.amazonaws.util.ContentLengthValidationInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetJobOutputResultJsonUnmarshaller
implements Unmarshaller<GetJobOutputResult, JsonUnmarshallerContext> {
    private static GetJobOutputResultJsonUnmarshaller instance;

    @Override
    public GetJobOutputResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetJobOutputResult getJobOutputResult = new GetJobOutputResult();
        if (context.isStartOfDocument()) {
            if (context.getHeader("x-amz-sha256-tree-hash") != null) {
                getJobOutputResult.setChecksum(context.getHeader("x-amz-sha256-tree-hash"));
            }
            if (context.getHeader("Content-Range") != null) {
                getJobOutputResult.setContentRange(context.getHeader("Content-Range"));
            }
            if (context.getHeader("Accept-Ranges") != null) {
                getJobOutputResult.setAcceptRanges(context.getHeader("Accept-Ranges"));
            }
            if (context.getHeader("Content-Type") != null) {
                getJobOutputResult.setContentType(context.getHeader("Content-Type"));
            }
            if (context.getHeader("x-amz-archive-description") != null) {
                getJobOutputResult.setArchiveDescription(context.getHeader("x-amz-archive-description"));
            }
        }
        getJobOutputResult.setStatus(context.getHttpResponse().getStatusCode());
        getJobOutputResult.setBody(new ContentLengthValidationInputStream(context.getHttpResponse().getContent(), Long.parseLong(context.getHeader("Content-Length"))));
        return getJobOutputResult;
    }

    public static GetJobOutputResultJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GetJobOutputResultJsonUnmarshaller();
        }
        return instance;
    }
}

