/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.opsworks.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.opsworks.model.DescribeVolumesRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringInputStream;
import com.cloudera.com.amazonaws.util.StringUtils;
import com.cloudera.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    @Override
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        if (describeVolumesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVolumesRequest> request = new DefaultRequest<DescribeVolumesRequest>(describeVolumesRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.DescribeVolumes";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag volumeIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeVolumesRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(describeVolumesRequest.getInstanceId());
            }
            if (describeVolumesRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(describeVolumesRequest.getStackId());
            }
            if (describeVolumesRequest.getRaidArrayId() != null) {
                jsonWriter.key("RaidArrayId").value(describeVolumesRequest.getRaidArrayId());
            }
            if (!((volumeIdsList = (ListWithAutoConstructFlag)describeVolumesRequest.getVolumeIds()) == null || volumeIdsList.isAutoConstruct() && volumeIdsList.isEmpty())) {
                jsonWriter.key("VolumeIds");
                jsonWriter.array();
                for (String volumeIdsListValue : volumeIdsList) {
                    if (volumeIdsListValue == null) continue;
                    jsonWriter.value(volumeIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

