/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.s3.model;

import com.cloudera.com.amazonaws.services.s3.model.EncryptionMaterials;
import com.cloudera.com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.cloudera.com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticEncryptionMaterialsProvider
implements EncryptionMaterialsProvider {
    private final EncryptionMaterials materials;

    public StaticEncryptionMaterialsProvider(EncryptionMaterials materials) {
        this.materials = materials;
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials() {
        return this.materials;
    }

    @Override
    public void refresh() {
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(Map<String, String> materialDescIn) {
        EncryptionMaterials accessorMaterials;
        Map<String, String> materialDesc = this.materials.getMaterialsDescription();
        if (materialDescIn != null && materialDescIn.equals(materialDesc)) {
            return this.materials;
        }
        EncryptionMaterialsAccessor accessor = this.materials.getAccessor();
        if (accessor != null && (accessorMaterials = accessor.getEncryptionMaterials(materialDescIn)) != null) {
            return accessorMaterials;
        }
        boolean noMaterialDescIn = materialDescIn == null || materialDescIn.size() == 0;
        boolean noMaterialDesc = materialDesc == null || materialDesc.size() == 0;
        return noMaterialDescIn && noMaterialDesc ? this.materials : null;
    }
}

