/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpledb.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.simpledb.model.Attribute;
import com.cloudera.com.amazonaws.services.simpledb.model.UpdateCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String domainName;
    private String itemName;
    private ListWithAutoConstructFlag<Attribute> attributes;
    private UpdateCondition expected;

    public DeleteAttributesRequest() {
    }

    public DeleteAttributesRequest(String domainName, String itemName) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
    }

    public DeleteAttributesRequest(String domainName, String itemName, List<Attribute> attributes) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
    }

    public DeleteAttributesRequest(String domainName, String itemName, List<Attribute> attributes, UpdateCondition expected) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
        this.setExpected(expected);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DeleteAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public DeleteAttributesRequest withItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListWithAutoConstructFlag();
            this.attributes.setAutoConstruct(true);
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        ListWithAutoConstructFlag attributesCopy = new ListWithAutoConstructFlag(attributes.size());
        attributesCopy.addAll(attributes);
        this.attributes = attributesCopy;
    }

    public DeleteAttributesRequest withAttributes(Attribute ... attributes) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<Attribute>(attributes.length));
        }
        for (Attribute value : attributes) {
            this.getAttributes().add(value);
        }
        return this;
    }

    public DeleteAttributesRequest withAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
        } else {
            ListWithAutoConstructFlag attributesCopy = new ListWithAutoConstructFlag(attributes.size());
            attributesCopy.addAll(attributes);
            this.attributes = attributesCopy;
        }
        return this;
    }

    public UpdateCondition getExpected() {
        return this.expected;
    }

    public void setExpected(UpdateCondition expected) {
        this.expected = expected;
    }

    public DeleteAttributesRequest withExpected(UpdateCondition expected) {
        this.expected = expected;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItemName() != null) {
            sb.append("ItemName: " + this.getItemName() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getExpected() != null) {
            sb.append("Expected: " + this.getExpected());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItemName() == null ? 0 : this.getItemName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getExpected() == null ? 0 : this.getExpected().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAttributesRequest)) {
            return false;
        }
        DeleteAttributesRequest other = (DeleteAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItemName() == null ^ this.getItemName() == null) {
            return false;
        }
        if (other.getItemName() != null && !other.getItemName().equals(this.getItemName())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        return other.getExpected() == null || other.getExpected().equals(this.getExpected());
    }
}

