/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.aspectj;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetry;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRetryingExecutor;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.interceptors.ExponentialRetryPolicy;
import java.util.Arrays;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ExponentialRetryAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ExponentialRetryAspect ajc$perSingletonInstance;

    @Around(value="execution(@com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetry * *(..)) && @annotation(retryAnnotation)")
    public Object retry(ProceedingJoinPoint pjp, ExponentialRetry retryAnnotation) throws Throwable {
        ExponentialRetryPolicy retryPolicy = this.createExponentialRetryPolicy(retryAnnotation);
        WorkflowClock clock = new DecisionContextProviderImpl().getDecisionContext().getWorkflowClock();
        AsyncRetryingExecutor executor = new AsyncRetryingExecutor(retryPolicy, clock);
        Settable result = this.isVoidReturnType(pjp) ? null : new Settable();
        DecoratorInvocationHandler handler = new DecoratorInvocationHandler(pjp, result);
        executor.execute(handler);
        return result;
    }

    private boolean isVoidReturnType(ProceedingJoinPoint pjp) {
        boolean isVoidReturnType = false;
        Signature signature = pjp.getStaticPart().getSignature();
        if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            isVoidReturnType = methodSignature != null ? Void.TYPE.equals(methodSignature.getReturnType()) : false;
        }
        return isVoidReturnType;
    }

    private ExponentialRetryPolicy createExponentialRetryPolicy(ExponentialRetry retryAnnotation) {
        ExponentialRetryPolicy retryPolicy = ((ExponentialRetryPolicy)((ExponentialRetryPolicy)new ExponentialRetryPolicy(retryAnnotation.initialRetryIntervalSeconds()).withExceptionsToRetry(Arrays.asList(retryAnnotation.exceptionsToRetry()))).withExceptionsToExclude(Arrays.asList(retryAnnotation.excludeExceptions()))).withBackoffCoefficient(retryAnnotation.backoffCoefficient()).withMaximumRetryIntervalSeconds(retryAnnotation.maximumRetryIntervalSeconds()).withRetryExpirationIntervalSeconds(retryAnnotation.retryExpirationSeconds()).withMaximumAttempts(retryAnnotation.maximumAttempts());
        retryPolicy.validate();
        return retryPolicy;
    }

    public static ExponentialRetryAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.cloudera.com.amazonaws.services.simpleworkflow.flow.aspectj.ExponentialRetryAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ExponentialRetryAspect.ajc$perSingletonInstance = new ExponentialRetryAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private final class DecoratorInvocationHandler
    implements AsyncRunnable {
        private final ProceedingJoinPoint pjp;
        private final Settable result;

        public DecoratorInvocationHandler(ProceedingJoinPoint pjp, Settable result) {
            this.pjp = pjp;
            this.result = result;
        }

        @Override
        public void run() throws Throwable {
            if (this.result != null) {
                this.result.unchain();
                this.result.chain((Promise)this.pjp.proceed());
            } else {
                this.pjp.proceed();
            }
        }
    }
}

