/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.core;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.AndPromise;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Promises {
    private Promises() {
    }

    public static <T> Promise<List<T>> listOfPromisesToPromise(final List<Promise<T>> list) {
        final Settable<List<T>> result = new Settable<List<T>>();
        AndPromise andPromise = new AndPromise(list);
        new Task(new Promise[]{andPromise}){

            protected void doExecute() throws Throwable {
                ArrayList extracted = new ArrayList(list.size());
                for (Promise promise : list) {
                    extracted.add(promise.get());
                }
                result.set(extracted);
            }
        };
        return result;
    }

    public static <K, V> Promise<Map<K, V>> mapOfPromisesToPromise(final Map<K, Promise<V>> map) {
        final Settable<Map<K, V>> result = new Settable<Map<K, V>>();
        AndPromise andPromise = new AndPromise(map.values());
        new Task(new Promise[]{andPromise}){

            protected void doExecute() throws Throwable {
                HashMap extracted = new HashMap(map.size());
                for (Map.Entry pair : map.entrySet()) {
                    extracted.put(pair.getKey(), ((Promise)pair.getValue()).get());
                }
                result.set(extracted);
            }
        };
        return result;
    }

    public static <T> Promise<Set<T>> setOfPromisesToPromise(final Set<Promise<T>> set) {
        final Settable<Set<T>> result = new Settable<Set<T>>();
        AndPromise andPromise = new AndPromise(set);
        new Task(new Promise[]{andPromise}){

            protected void doExecute() throws Throwable {
                HashSet extracted = new HashSet(set.size());
                for (Promise promise : set) {
                    extracted.add(promise.get());
                }
                result.set(extracted);
            }
        };
        return result;
    }
}

