/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.DocIdSetBuilder;

final class RangeTreeReader
implements Accountable {
    private final long[] blockFPs;
    private final long[] blockMinValues;
    final IndexInput in;
    final long globalMaxValue;
    final int approxDocsPerBlock;

    public RangeTreeReader(IndexInput in) throws IOException {
        int i;
        int numLeaves = in.readVInt();
        this.approxDocsPerBlock = in.readVInt();
        this.blockMinValues = new long[numLeaves];
        for (i = 0; i < numLeaves; ++i) {
            this.blockMinValues[i] = in.readLong();
        }
        this.blockFPs = new long[numLeaves];
        for (i = 0; i < numLeaves; ++i) {
            this.blockFPs[i] = in.readVLong();
        }
        this.globalMaxValue = in.readLong();
        this.in = in;
    }

    public long getMinValue() {
        return this.blockMinValues[0];
    }

    public long getMaxValue() {
        return this.globalMaxValue;
    }

    public DocIdSet intersect(long minIncl, long maxIncl, SortedNumericDocValues sndv, int maxDoc) throws IOException {
        int endBlockIncl;
        if (minIncl > maxIncl) {
            return DocIdSet.EMPTY;
        }
        if (minIncl > this.globalMaxValue || maxIncl < this.blockMinValues[0]) {
            return DocIdSet.EMPTY;
        }
        QueryState state = new QueryState(this.in.clone(), maxDoc, minIncl, maxIncl, sndv);
        int startBlockIncl = Arrays.binarySearch(this.blockMinValues, minIncl);
        if (startBlockIncl >= 0) {
            while (startBlockIncl > 0 && this.blockMinValues[startBlockIncl] == minIncl) {
                --startBlockIncl;
            }
        } else {
            startBlockIncl = Math.max(-startBlockIncl - 2, 0);
        }
        if ((endBlockIncl = Arrays.binarySearch(this.blockMinValues, maxIncl)) >= 0) {
            while (endBlockIncl < this.blockMinValues.length - 1 && this.blockMinValues[endBlockIncl] == maxIncl) {
                ++endBlockIncl;
            }
        } else {
            endBlockIncl = Math.max(-endBlockIncl - 2, 0);
        }
        assert (startBlockIncl <= endBlockIncl);
        state.in.seek(this.blockFPs[startBlockIncl]);
        state.docs.grow(this.approxDocsPerBlock * (endBlockIncl - startBlockIncl + 1));
        int hitCount = 0;
        for (int block = startBlockIncl; block <= endBlockIncl; ++block) {
            boolean doFilter = this.blockMinValues[block] <= minIncl || block == this.blockMinValues.length - 1 || this.blockMinValues[block + 1] >= maxIncl;
            int newCount = doFilter ? this.addSome(state) : this.addAll(state);
            hitCount += newCount;
        }
        return state.docs.build((long)hitCount);
    }

    private int addAll(QueryState state) throws IOException {
        int count = state.in.readVInt();
        state.docs.grow(count);
        for (int i = 0; i < count; ++i) {
            int docID = state.in.readInt();
            state.docs.add(docID);
        }
        return count;
    }

    private int addSome(QueryState state) throws IOException {
        int hitCount = 0;
        int count = state.in.readVInt();
        state.docs.grow(count);
        block0: for (int i = 0; i < count; ++i) {
            int docID = state.in.readInt();
            state.sndv.setDocument(docID);
            int docValueCount = state.sndv.count();
            for (int j = 0; j < docValueCount; ++j) {
                long value = state.sndv.valueAt(j);
                if (value < state.minValueIncl || value > state.maxValueIncl) continue;
                state.docs.add(docID);
                ++hitCount;
                continue block0;
            }
        }
        return hitCount;
    }

    public long ramBytesUsed() {
        return this.blockMinValues.length * 8 + this.blockFPs.length * 8;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static final class QueryState {
        final IndexInput in;
        final DocIdSetBuilder docs;
        final long minValueIncl;
        final long maxValueIncl;
        final SortedNumericDocValues sndv;

        public QueryState(IndexInput in, int maxDoc, long minValueIncl, long maxValueIncl, SortedNumericDocValues sndv) {
            this.in = in;
            this.docs = new DocIdSetBuilder(maxDoc);
            this.minValueIncl = minValueIncl;
            this.maxValueIncl = maxValueIncl;
            this.sndv = sndv;
        }
    }
}

