/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.BasePluginTypeExposer;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.osgi.OSGIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationBasedOsgiPlugin
extends OSGIPlugin {
    private BasePluginType basePluginType;
    private BasePluginTypeExposer exposer;
    private Object bean;
    private Annotation annotation;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public AnnotationBasedOsgiPlugin(Class<PluginTypeInterface> pluginTypeInterface, Object bean, String id, Map<String, String> classToBeanMap) throws IllegalAccessException, InstantiationException {
        this.bean = bean;
        if (!BasePluginType.class.isAssignableFrom(pluginTypeInterface)) {
            throw new IllegalArgumentException("PluginTypeInterface must extend BasePluginType");
        }
        boolean trySingleton = false;
        Constructor<PluginTypeInterface> constructor = null;
        try {
            constructor = pluginTypeInterface.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.logger.debug("Error getting Constructor for BasePluginType of [ " + pluginTypeInterface.getName() + " ]");
            trySingleton = true;
        }
        if (constructor != null && constructor.isAccessible()) {
            try {
                this.basePluginType = (BasePluginType)constructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                this.logger.debug("Error calling Constructor for BasePluginType of [ " + pluginTypeInterface.getName() + " ]");
                trySingleton = true;
            }
        } else {
            trySingleton = true;
        }
        if (trySingleton) {
            Method getInstance = null;
            try {
                getInstance = pluginTypeInterface.getMethod("getInstance", new Class[0]);
                if (getInstance != null) {
                    this.basePluginType = (BasePluginType)getInstance.invoke(pluginTypeInterface, new Object[0]);
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        Class annotationCls = pluginTypeInterface.getAnnotation(PluginAnnotationType.class).value();
        this.annotation = bean.getClass().getAnnotation(annotationCls);
        if (this.basePluginType == null) {
            throw new IllegalStateException("Bean's PluginType could not be constructed, <pen:di-plugin> cannot be used.");
        }
        if (this.annotation == null) {
            throw new IllegalStateException("Bean class does not have required PluginType annotation");
        }
        super.setPluginTypeInterface(pluginTypeInterface);
        if (classToBeanMap == null) {
            classToBeanMap = new HashMap<String, String>();
        }
        classToBeanMap.put(this.getMainType().getName(), id);
        super.setClassToBeanMap(classToBeanMap);
        this.exposer = new BasePluginTypeExposer(this.basePluginType, bean);
    }

    @Override
    public String getDescription() {
        return this.exposer.extractDesc(this.annotation);
    }

    @Override
    public String getCategory() {
        return this.exposer.extractCategory(this.annotation);
    }

    @Override
    public String getID() {
        return this.exposer.extractID(this.annotation);
    }

    @Override
    public String getImageFile() {
        return this.exposer.extractImageFile(this.annotation);
    }

    @Override
    public Class<?> getMainType() {
        PluginMainClassType mainType = this.getPluginType().getAnnotation(PluginMainClassType.class);
        if (mainType != null) {
            return mainType.value();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.exposer.extractName(this.annotation);
    }

    @Override
    public String getCasesUrl() {
        return this.exposer.extractCasesUrl(this.annotation);
    }

    @Override
    public String getDocumentationUrl() {
        return this.exposer.extractDocumentationUrl(this.annotation);
    }
}

