/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.plugins.ClassLoadingPluginInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.osgi.api.BeanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIPlugin
implements PluginInterface,
ClassLoadingPluginInterface {
    private OSGIPluginTracker osgiPluginTracker;
    private String category;
    private String description;
    private String errorHelpFile;
    private String ID;
    private String name;
    private String imageFile;
    private Class<Object> mainType;
    private Class<PluginTypeInterface> pluginTypeInterface;
    private BeanFactory beanFactory;
    private String casesUrl;
    private String documentationUrl;
    private String forumUrl;
    private Map<String, String> classToBeanMap = new HashMap<String, String>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public OSGIPlugin() {
        this.osgiPluginTracker = OSGIPluginTracker.getInstance();
    }

    protected void setOsgiPluginTracker(OSGIPluginTracker osgiPluginTracker) {
        this.osgiPluginTracker = osgiPluginTracker;
    }

    public String getCategory() {
        return OSGIPlugin.translateString(this.category);
    }

    private static String translateString(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("i18n:")) {
            String[] parts = str.split(":");
            if (parts.length != 3) {
                return str;
            }
            return BaseMessages.getString((String)parts[1], (String)parts[2]);
        }
        return str;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Map<Class<?>, String> getClassMap() {
        HashMap classMap = new HashMap();
        for (String typeName : this.getClassToBeanMap().keySet()) {
            try {
                Class<?> type = Class.forName(typeName);
                Object bean = this.loadClass(type);
                classMap.put(type, bean.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                this.logger.error("Error instancing plugin class: ", (Throwable)e);
            }
        }
        return classMap;
    }

    public String getDescription() {
        return OSGIPlugin.translateString(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getErrorHelpFile() {
        return this.errorHelpFile;
    }

    public void setErrorHelpFile(String errorHelpFile) {
        this.errorHelpFile = errorHelpFile;
    }

    public String[] getIds() {
        return new String[]{this.getID()};
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public List<String> getLibraries() {
        return Collections.emptyList();
    }

    public Class<?> getMainType() {
        return this.mainType;
    }

    public void setMainType(Class<Object> mainType) {
        this.mainType = mainType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URL getPluginDirectory() {
        return null;
    }

    public Class<? extends PluginTypeInterface> getPluginType() {
        return this.pluginTypeInterface;
    }

    public boolean isNativePlugin() {
        return false;
    }

    public boolean isSeparateClassLoaderNeeded() {
        return false;
    }

    public boolean matches(String id) {
        return this.getID().equals(id);
    }

    public void setPluginTypeInterface(Class<PluginTypeInterface> pluginTypeInterface) {
        this.pluginTypeInterface = pluginTypeInterface;
    }

    public <T> T loadClass(Class<T> pluginClass) {
        String id = this.classToBeanMap.get(pluginClass.getName());
        if (id != null) {
            return this.osgiPluginTracker.getBean(pluginClass, this, id);
        }
        try {
            return pluginClass.newInstance();
        }
        catch (Exception e) {
            this.logger.error("Error instancing plugin class: ", (Throwable)e);
            return null;
        }
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ClassLoader getClassLoader() {
        return this.osgiPluginTracker.getClassLoader(this);
    }

    public String getCasesUrl() {
        return this.casesUrl;
    }

    public void setCasesUrl(String casesUrl) {
        this.casesUrl = casesUrl;
    }

    public String getDocumentationUrl() {
        return Const.getDocUrl((String)this.documentationUrl);
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public String getForumUrl() {
        return this.forumUrl;
    }

    public void setForumUrl(String forumUrl) {
        this.forumUrl = forumUrl;
    }

    public String getClassLoaderGroup() {
        return null;
    }

    public void setClassLoaderGroup(String arg0) {
    }

    public Map<String, String> getClassToBeanMap() {
        return this.classToBeanMap;
    }

    public void setClassToBeanMap(Map<String, String> classToBeanMap) {
        this.classToBeanMap = classToBeanMap;
    }
}

