/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.AbstractDelegate;
import org.pentaho.di.repository.pur.ITransformer;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.SharedObjectAssembler;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;

public class SlaveDelegate
extends AbstractDelegate
implements ITransformer,
SharedObjectAssembler<SlaveServer>,
Serializable {
    private static final long serialVersionUID = -8084266831877112729L;
    private static final String NODE_ROOT = "Slave";
    private static final String PROP_PASSWORD = "PASSWORD";
    private static final String PROP_USERNAME = "USERNAME";
    private static final String PROP_PORT = "PORT";
    private static final String PROP_HOST_NAME = "HOST_NAME";
    private static final String PROP_PROXY_HOST_NAME = "PROXY_HOST_NAME";
    private static final String PROP_PROXY_PORT = "PROXY_PORT";
    private static final String PROP_WEBAPP_NAME = "WEBAPP_NAME";
    private static final String PROP_NON_PROXY_HOSTS = "NON_PROXY_HOSTS";
    private static final String PROP_MASTER = "MASTER";
    private PurRepository repo;

    public SlaveDelegate(PurRepository repo) {
        this.repo = repo;
    }

    @Override
    public RepositoryElementInterface dataNodeToElement(DataNode rootNode) throws KettleException {
        SlaveServer slaveServer = new SlaveServer();
        this.dataNodeToElement(rootNode, (RepositoryElementInterface)slaveServer);
        return slaveServer;
    }

    @Override
    public void dataNodeToElement(DataNode rootNode, RepositoryElementInterface element) throws KettleException {
        SlaveServer slaveServer = (SlaveServer)element;
        slaveServer.setHostname(this.getString(rootNode, PROP_HOST_NAME));
        slaveServer.setPort(this.getString(rootNode, PROP_PORT));
        slaveServer.setUsername(this.getString(rootNode, PROP_USERNAME));
        slaveServer.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)this.getString(rootNode, PROP_PASSWORD)));
        slaveServer.setProxyHostname(this.getString(rootNode, PROP_PROXY_HOST_NAME));
        slaveServer.setProxyPort(this.getString(rootNode, PROP_PROXY_PORT));
        slaveServer.setWebAppName(this.getString(rootNode, PROP_WEBAPP_NAME));
        slaveServer.setNonProxyHosts(this.getString(rootNode, PROP_NON_PROXY_HOSTS));
        slaveServer.setMaster(rootNode.getProperty(PROP_MASTER).getBoolean());
    }

    @Override
    public DataNode elementToDataNode(RepositoryElementInterface element) throws KettleException {
        SlaveServer slaveServer = (SlaveServer)element;
        DataNode rootNode = new DataNode(NODE_ROOT);
        rootNode.setProperty(PROP_HOST_NAME, slaveServer.getHostname());
        rootNode.setProperty(PROP_PORT, slaveServer.getPort());
        rootNode.setProperty(PROP_WEBAPP_NAME, slaveServer.getWebAppName());
        rootNode.setProperty(PROP_USERNAME, slaveServer.getUsername());
        rootNode.setProperty(PROP_PASSWORD, Encr.encryptPasswordIfNotUsingVariables((String)slaveServer.getPassword()));
        rootNode.setProperty(PROP_PROXY_HOST_NAME, slaveServer.getProxyHostname());
        rootNode.setProperty(PROP_PROXY_PORT, slaveServer.getProxyPort());
        rootNode.setProperty(PROP_NON_PROXY_HOSTS, slaveServer.getNonProxyHosts());
        rootNode.setProperty(PROP_MASTER, slaveServer.isMaster());
        return rootNode;
    }

    protected Repository getRepository() {
        return this.repo;
    }

    @Override
    public SlaveServer assemble(RepositoryFile file, NodeRepositoryFileData data, VersionSummary version) throws KettleException {
        SlaveServer slaveServer = (SlaveServer)this.dataNodeToElement(data.getNode());
        slaveServer.setName(file.getTitle());
        slaveServer.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
        slaveServer.setObjectRevision(this.repo.createObjectRevision(version));
        slaveServer.clearChanged();
        return slaveServer;
    }
}

