/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.pur.RepositoryObjectAccessException;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.repository.RepositoryExtension;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEERepositoryDirectory;
import org.pentaho.di.ui.repository.pur.services.ITrashService;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.BrowseController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectories;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObjects;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class TrashBrowseController
extends BrowseController
implements Serializable {
    private static final long serialVersionUID = -3822571463115111325L;
    private static final Class<?> PKG = IUIEEUser.class;
    protected ResourceBundle messages = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };
    protected XulTree trashFileTable;
    protected XulDeck deck;
    protected List<UIDeletedObject> selectedTrashFileItems;
    protected TrashDirectory trashDir = new TrashDirectory();
    protected ITrashService trashService;
    protected List<ITrashService.IDeletedObject> trash;
    protected XulButton undeleteButton;
    protected XulButton deleteButton;

    protected Binding createDirectoryBinding() {
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        return this.bf.createBinding((Object)this, "repositoryDirectory", (Object)this.folderTree, "elements", new BindingConvertor[]{new BindingConvertor<UIRepositoryDirectory, UIRepositoryDirectory>(){

            public UIRepositoryDirectory sourceToTarget(UIRepositoryDirectory value) {
                if (value == null || value.size() == 0) {
                    return null;
                }
                if (!value.get(value.size() - 1).equals(TrashBrowseController.this.trashDir)) {
                    value.getChildren().add((Object)TrashBrowseController.this.trashDir);
                }
                return value;
            }

            public UIRepositoryDirectory targetToSource(UIRepositoryDirectory value) {
                return value;
            }
        }});
    }

    public void init(Repository repository) throws ControllerInitializationException {
        super.init(repository);
        try {
            this.trashService = (ITrashService)repository.getService(ITrashService.class);
        }
        catch (Throwable e) {
            throw new ControllerInitializationException(e);
        }
    }

    protected void doCreateBindings() {
        this.deck = (XulDeck)this.document.getElementById("browse-tab-right-panel-deck");
        this.trashFileTable = (XulTree)this.document.getElementById("deleted-file-table");
        this.deleteButton = (XulButton)this.document.getElementById("delete-button");
        this.undeleteButton = (XulButton)this.document.getElementById("undelete-button");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        BindingConvertor<List<UIDeletedObject>, Boolean> buttonConverter = new BindingConvertor<List<UIDeletedObject>, Boolean>(){

            public Boolean sourceToTarget(List<UIDeletedObject> value) {
                if (value != null && value.size() > 0) {
                    return true;
                }
                return false;
            }

            public List<UIDeletedObject> targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.createBinding((Object)this.trashFileTable, "selectedItems", (Object)this, "selectedTrashFileItems", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.trashFileTable, "selectedItems", (Object)this.deleteButton, "!disabled", new BindingConvertor[]{buttonConverter});
        this.bf.createBinding((Object)this.trashFileTable, "selectedItems", (Object)this.undeleteButton, "!disabled", new BindingConvertor[]{buttonConverter});
        this.bf.createBinding((Object)this.trashFileTable, "selectedItems", "trash-context-delete", "!disabled", new BindingConvertor[]{buttonConverter});
        this.bf.createBinding((Object)this.trashFileTable, "selectedItems", "trash-context-restore", "!disabled", new BindingConvertor[]{buttonConverter});
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this, "trash", (Object)this.trashFileTable, "elements", new BindingConvertor[]{new BindingConvertor<List<ITrashService.IDeletedObject>, List<UIDeletedObject>>(){

            public List<UIDeletedObject> sourceToTarget(List<ITrashService.IDeletedObject> trash) {
                ArrayList<UIDeletedObject> newList = new ArrayList<UIDeletedObject>(trash.size());
                for (ITrashService.IDeletedObject obj : trash) {
                    newList.add(new UIDeletedObject(obj));
                }
                Collections.sort(newList, new UIDeletedObjectComparator());
                return newList;
            }

            public List<ITrashService.IDeletedObject> targetToSource(List<UIDeletedObject> elements) {
                return null;
            }
        }});
    }

    public void setSelectedFolderItems(List<UIRepositoryDirectory> selectedFolderItems) {
        if (selectedFolderItems != null && selectedFolderItems.size() == 1 && selectedFolderItems.get(0).equals((Object)this.trashDir)) {
            block4: {
                try {
                    this.setTrash(this.trashService.getTrash());
                }
                catch (KettleException e) {
                    if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block4;
                    throw new RuntimeException(e);
                }
            }
            this.deck.setSelectedIndex(1);
        } else {
            this.deck.setSelectedIndex(0);
            super.setSelectedFolderItems(selectedFolderItems);
        }
    }

    public void setTrash(List<ITrashService.IDeletedObject> trash) {
        this.trash = trash;
        this.firePropertyChange("trash", null, trash);
    }

    public List<ITrashService.IDeletedObject> getTrash() {
        return this.trash;
    }

    protected void moveFiles(List<UIRepositoryObject> objects, UIRepositoryDirectory targetDirectory) throws Exception {
        if (targetDirectory != this.trashDir) {
            super.moveFiles(objects, targetDirectory);
        } else {
            for (UIRepositoryObject o : objects) {
                this.deleteContent(o);
            }
        }
    }

    public void delete() {
        if (this.selectedTrashFileItems != null && this.selectedTrashFileItems.size() > 0) {
            ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
            for (UIDeletedObject uiObj : this.selectedTrashFileItems) {
                ids.add(uiObj.getId());
            }
            try {
                this.trashService.delete(ids);
                this.setTrash(this.trashService.getTrash());
            }
            catch (Throwable th) {
                if (this.mainController == null || !this.mainController.handleLostRepository(th)) {
                    this.displayExceptionMessage(BaseMessages.getString(PKG, (String)"TrashBrowseController.UnableToDeleteFile", (String[])new String[]{th.getLocalizedMessage()}));
                }
            }
        } else {
            throw new RuntimeException();
        }
    }

    public void undelete() {
        block11: {
            ArrayList<UIDeletedObject> selectedTrashFileItemsSnapshot = new ArrayList<UIDeletedObject>(this.selectedTrashFileItems);
            if (selectedTrashFileItemsSnapshot != null && selectedTrashFileItemsSnapshot.size() > 0) {
                ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
                for (UIDeletedObject uiObj : selectedTrashFileItemsSnapshot) {
                    ids.add(uiObj.getId());
                }
                try {
                    this.trashService.undelete(ids);
                    this.setTrash(this.trashService.getTrash());
                    for (UIDeletedObject uiObj : selectedTrashFileItemsSnapshot) {
                        RepositoryDirectoryInterface dir;
                        for (dir = this.repository.findDirectory(uiObj.getOriginalParentPath()); dir != null && this.dirMap.get(dir.getObjectId()) == null; dir = dir.getParent()) {
                        }
                        if (dir != null) {
                            ((UIRepositoryDirectory)this.dirMap.get(dir.getObjectId())).refresh();
                        }
                        if (RepositoryObjectType.TRANSFORMATION.name().equals(uiObj.getType())) {
                            TransMeta transMeta = this.repository.loadTransformation(uiObj.getId(), null);
                            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransAfterOpen.id, (Object)transMeta);
                            transMeta.clearChanged();
                            continue;
                        }
                        if (RepositoryObjectType.JOB.name().equals(uiObj.getType())) continue;
                        RepositoryDirectoryInterface actualDir = this.repository.findDirectory(uiObj.getOriginalParentPath() + "/" + uiObj.getName());
                        if (actualDir != null) {
                            ArrayList<RepositoryElementMetaInterface> transformations = new ArrayList<RepositoryElementMetaInterface>();
                            TrashBrowseController.getAllTransformations(actualDir, transformations);
                            for (RepositoryElementMetaInterface repositoryElementMetaInterface : transformations) {
                                TransMeta transMeta = this.repository.loadTransformation(repositoryElementMetaInterface.getObjectId(), null);
                                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransAfterOpen.id, (Object)transMeta);
                                transMeta.clearChanged();
                            }
                            continue;
                        }
                        this.displayExceptionMessage(BaseMessages.getString(PKG, (String)"TrashBrowseController.UnableToRestoreDirectory", (String[])new String[]{uiObj.getOriginalParentPath() + "/" + uiObj.getName()}));
                    }
                    this.deck.setSelectedIndex(1);
                }
                catch (Throwable th) {
                    if (this.mainController == null || !this.mainController.handleLostRepository(th)) {
                        this.displayExceptionMessage(BaseMessages.getString(PKG, (String)"TrashBrowseController.UnableToRestoreFile", (String[])new String[]{th.getLocalizedMessage()}));
                    }
                    break block11;
                }
            }
            throw new RuntimeException();
        }
    }

    private static void getAllTransformations(RepositoryDirectoryInterface repositoryObject, List<RepositoryElementMetaInterface> objectsTransformations) throws KettleException {
        if (repositoryObject.getChildren() != null && repositoryObject.getChildren().size() > 0) {
            for (RepositoryDirectoryInterface subDirectory : repositoryObject.getChildren()) {
                TrashBrowseController.getAllTransformations(subDirectory, objectsTransformations);
            }
        }
        repositoryObject.getRepositoryObjects().stream().filter(e -> RepositoryObjectType.TRANSFORMATION.equals((Object)e.getObjectType())).forEach(objectsTransformations::add);
    }

    public void setSelectedTrashFileItems(List<UIDeletedObject> selectedTrashFileItems) {
        this.selectedTrashFileItems = selectedTrashFileItems;
    }

    protected void deleteFolder(UIRepositoryDirectory repoDir) throws Exception {
        this.deleteContent((UIRepositoryObject)repoDir);
    }

    protected void deleteContent(final UIRepositoryObject repoObject) throws Exception {
        block8: {
            try {
                try {
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.AfterDeleteRepositoryObject.id, (Object)new RepositoryExtension(repoObject));
                }
                catch (Exception ex) {
                    LogChannel.GENERAL.logError("Error calling AfterDeleteRepositoryObject extension point", (Throwable)ex);
                }
                repoObject.delete();
            }
            catch (KettleException ke) {
                if (this.repoDir != null) {
                    this.repoDir.refresh();
                }
                if (ke.getCause() instanceof RepositoryObjectAccessException) {
                    this.moveDeletePrompt(ke, repoObject, new XulDialogCallback<Object>(){

                        public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                            block3: {
                                if (returnCode == XulDialogCallback.Status.ACCEPT) {
                                    try {
                                        ((UIEERepositoryDirectory)repoObject).delete(true);
                                    }
                                    catch (Exception e) {
                                        if (TrashBrowseController.this.mainController != null && TrashBrowseController.this.mainController.handleLostRepository((Throwable)e)) break block3;
                                        TrashBrowseController.this.displayExceptionMessage(BaseMessages.getString((Class)PKG, (String)e.getLocalizedMessage(), (String[])new String[0]));
                                    }
                                }
                            }
                        }

                        public void onError(XulComponent sender, Throwable t) {
                            if (TrashBrowseController.this.mainController == null || !TrashBrowseController.this.mainController.handleLostRepository(t)) {
                                throw new RuntimeException(t);
                            }
                        }
                    });
                }
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)ke)) break block8;
                throw ke;
            }
        }
        if (repoObject instanceof UIRepositoryDirectory) {
            this.directoryBinding.fireSourceChanged();
            if (this.repoDir != null) {
                this.repoDir.refresh();
            }
        }
        this.selectedItemsBinding.fireSourceChanged();
    }

    protected void renameRepositoryObject(final UIRepositoryObject repoObject) throws XulException {
        XulPromptBox prompt = this.promptForName(repoObject);
        prompt.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                block7: {
                    if (status == XulDialogCallback.Status.ACCEPT) {
                        final String newName = value;
                        try {
                            repoObject.setName(newName);
                        }
                        catch (KettleException ke) {
                            if (ke.getCause() instanceof RepositoryObjectAccessException) {
                                TrashBrowseController.this.moveDeletePrompt(ke, repoObject, new XulDialogCallback<Object>(){

                                    public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                                        block3: {
                                            if (returnCode == XulDialogCallback.Status.ACCEPT) {
                                                try {
                                                    ((UIEERepositoryDirectory)repoObject).setName(newName, true);
                                                }
                                                catch (Exception e) {
                                                    if (TrashBrowseController.this.mainController != null && TrashBrowseController.this.mainController.handleLostRepository((Throwable)e)) break block3;
                                                    TrashBrowseController.this.displayExceptionMessage(BaseMessages.getString((Class)PKG, (String)e.getLocalizedMessage(), (String[])new String[0]));
                                                }
                                            }
                                        }
                                    }

                                    public void onError(XulComponent sender, Throwable t) {
                                        if (TrashBrowseController.this.mainController == null || !TrashBrowseController.this.mainController.handleLostRepository(t)) {
                                            throw new RuntimeException(t);
                                        }
                                    }
                                });
                            } else if (TrashBrowseController.this.mainController == null || !TrashBrowseController.this.mainController.handleLostRepository((Throwable)ke)) {
                                throw new RuntimeException(ke);
                            }
                        }
                        catch (Exception e) {
                            if (TrashBrowseController.this.mainController != null && TrashBrowseController.this.mainController.handleLostRepository((Throwable)e)) break block7;
                            throw new RuntimeException(e);
                        }
                    }
                }
            }

            public void onError(XulComponent component, Throwable err) {
                if (TrashBrowseController.this.mainController == null || !TrashBrowseController.this.mainController.handleLostRepository(err)) {
                    throw new RuntimeException(err);
                }
            }
        });
        prompt.open();
    }

    protected boolean moveDeletePrompt(KettleException ke, UIRepositoryObject repoObject, final XulDialogCallback<Object> action) {
        block3: {
            if (ke.getCause() instanceof RepositoryObjectAccessException && ((RepositoryObjectAccessException)ke.getCause()).getObjectAccessType().equals((Object)RepositoryObjectAccessException.AccessExceptionType.USER_HOME_DIR) && repoObject instanceof UIEERepositoryDirectory) {
                try {
                    this.confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
                    this.confirmBox.setTitle(BaseMessages.getString(PKG, (String)"TrashBrowseController.DeleteHomeFolderWarningTitle", (String[])new String[0]));
                    this.confirmBox.setMessage(BaseMessages.getString(PKG, (String)"TrashBrowseController.DeleteHomeFolderWarningMessage", (String[])new String[0]));
                    this.confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    this.confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.Cancel", (String[])new String[0]));
                    this.confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

                        public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                            if (returnCode == XulDialogCallback.Status.ACCEPT) {
                                action.onClose(sender, returnCode, retVal);
                            }
                        }

                        public void onError(XulComponent sender, Throwable t) {
                            if (TrashBrowseController.this.mainController == null || !TrashBrowseController.this.mainController.handleLostRepository(t)) {
                                throw new RuntimeException(t);
                            }
                        }
                    });
                    this.confirmBox.open();
                }
                catch (Exception e) {
                    if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    protected void displayExceptionMessage(String msg) {
        this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
        this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
        this.messageBox.setMessage(msg);
        this.messageBox.open();
    }

    public static class UIDeletedObjectComparator
    implements Comparator<UIDeletedObject> {
        @Override
        public int compare(UIDeletedObject o1, UIDeletedObject o2) {
            int cat2;
            int cat1 = this.getValue(o1.getType());
            if (cat1 != (cat2 = this.getValue(o2.getType()))) {
                return cat1 - cat2;
            }
            String t1 = o1.getName();
            String t2 = o2.getName();
            if (t1 == null) {
                t1 = "";
            }
            if (t2 == null) {
                t2 = "";
            }
            return t1.compareToIgnoreCase(t2);
        }

        private int getValue(String type) {
            if (type == null) {
                return 10;
            }
            return 20;
        }
    }

    public static class UIDeletedObject
    extends XulEventSourceAdapter {
        private ITrashService.IDeletedObject obj;
        private static Comparator<UIDeletedObject> comparator = new UIDeletedObjectComparator();

        public UIDeletedObject(ITrashService.IDeletedObject obj) {
            this.obj = obj;
        }

        public String getOriginalParentPath() {
            return this.obj.getOriginalParentPath();
        }

        public String getDeletedDate() {
            Date date = this.obj.getDeletedDate();
            String str = null;
            if (date != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("d MMM yyyy HH:mm:ss z");
                str = sdf.format(date);
            }
            return str;
        }

        public String getType() {
            return this.obj.getType();
        }

        public ObjectId getId() {
            return this.obj.getId();
        }

        public String getName() {
            return this.obj.getName();
        }

        public String getImage() {
            if (RepositoryObjectType.TRANSFORMATION.name().equals(this.obj.getType())) {
                return "ui/images/transformation_tree.svg";
            }
            if (RepositoryObjectType.JOB.name().equals(this.obj.getType())) {
                return "ui/images/job_tree.svg";
            }
            return "ui/images/folder.svg";
        }

        public Comparator<UIDeletedObject> getComparator() {
            return comparator;
        }
    }

    protected class TrashDirectory
    extends UIEERepositoryDirectory {
        private static final long serialVersionUID = 6184312253116517468L;

        protected TrashDirectory() {
        }

        public String getImage() {
            return "ui/images/trash_tree.svg";
        }

        public String getName() {
            return BaseMessages.getString((Class)PKG, (String)"Trash", (String[])new String[0]);
        }

        public UIRepositoryDirectories getChildren() {
            return new UIRepositoryDirectories();
        }

        public UIRepositoryObjects getRepositoryObjects() throws KettleException {
            return new UIRepositoryObjects();
        }
    }
}

