/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.backend.executionengine.ExecutionEngine;
import org.apache.pig.backend.hadoop.executionengine.tez.TezExecutionEngine;
import org.apache.pig.impl.PigContext;
import org.apache.tez.client.TezClient;

public class TezExecType
implements ExecType {
    private static final Log LOG = LogFactory.getLog(TezExecType.class);
    private static final long serialVersionUID = 1L;
    private static final String[] modes = new String[]{"TEZ"};
    private static final String POM_PROPERTIES = "/META-INF/maven/org.apache.tez/tez-api/pom.properties";
    private static String tezVersion = null;

    @Override
    public boolean accepts(Properties properties) {
        String execTypeSpecified = properties.getProperty("exectype", "").toUpperCase();
        for (String mode : modes) {
            if (!execTypeSpecified.equals(mode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExecutionEngine getExecutionEngine(PigContext pigContext) {
        return new TezExecutionEngine(pigContext);
    }

    @Override
    public Class<? extends ExecutionEngine> getExecutionEngineClass() {
        return TezExecutionEngine.class;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public String name() {
        return "TEZ";
    }

    public String toString() {
        return this.name();
    }

    public static String getTezVersion() {
        if (tezVersion == null) {
            try {
                Properties prop = new Properties();
                prop.load(TezClient.class.getResourceAsStream(POM_PROPERTIES));
                tezVersion = prop.getProperty("version", "");
            }
            catch (Exception e) {
                LOG.info((Object)"Failed to load Tez pom.properties");
            }
        }
        return tezVersion == null ? "" : tezVersion;
    }
}

