/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.AbstractLookup;

final class InheritanceTree
implements Serializable,
AbstractLookup.Storage {
    private static final long serialVersionUID = 1L;
    private transient Node object = new Node(Object.class);
    private transient Map interfaces;
    private transient Map reg;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.object);
        if (this.interfaces != null) {
            Iterator iterator = this.interfaces.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Class clazz = (Class)entry.getKey();
                objectOutputStream.writeObject(clazz.getName());
                Object v = entry.getValue();
                if (!(v instanceof Collection) && !(v instanceof AbstractLookup.Pair)) {
                    throw new ClassCastException(String.valueOf(v));
                }
                objectOutputStream.writeObject(v);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        this.object = (Node)objectInputStream.readObject();
        this.interfaces = new WeakHashMap();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        while ((string = (String)objectInputStream.readObject()) != null) {
            Object object = objectInputStream.readObject();
            if (!(object instanceof Collection) && !(object instanceof AbstractLookup.Pair)) {
                throw new ClassCastException(String.valueOf(object));
            }
            Class<?> clazz = Class.forName(string, false, classLoader);
            this.interfaces.put(clazz, object);
        }
    }

    public boolean add(AbstractLookup.Pair pair, Object object) {
        ArrayList arrayList = (ArrayList)object;
        Node node = InheritanceTree.registerClass(this.object, pair);
        arrayList.add(node.getType());
        if (!node.assignItem(this, pair)) {
            return false;
        }
        boolean bl = this.registerInterface(pair, arrayList);
        return bl;
    }

    public void remove(AbstractLookup.Pair pair, Object object) {
        ArrayList arrayList = (ArrayList)object;
        Node node = InheritanceTree.removeClass(this.object, pair);
        if (node != null) {
            arrayList.add(node.getType());
        }
        this.removeInterface(pair, arrayList);
    }

    public void retainAll(Map map, Object object) {
        ArrayList arrayList = (ArrayList)object;
        this.retainAllInterface(map, arrayList);
        this.retainAllClasses(this.object, map, arrayList);
    }

    public Enumeration lookup(Class clazz) {
        if (clazz != null && clazz.isInterface()) {
            return this.searchInterface(clazz);
        }
        return this.searchClass(this.object, clazz);
    }

    public static boolean unsorted(Enumeration enumeration) {
        return enumeration instanceof NeedsSortEnum;
    }

    public void print(PrintStream printStream, boolean bl) {
        InheritanceTree.printNode(this.object, "", printStream, bl);
    }

    private static Node registerClass(Node node, AbstractLookup.Pair pair) {
        if (!node.accepts(pair)) {
            return null;
        }
        if (node.children != null) {
            Node node2;
            Iterator iterator = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(iterator)) != null) {
                Node node3 = InheritanceTree.registerClass(node2, pair);
                if (node3 == null) continue;
                return node3;
            }
        }
        return node;
    }

    private static Node removeClass(Node node, AbstractLookup.Pair pair) {
        if (!node.accepts(pair)) {
            return null;
        }
        if (node.items != null && node.items.remove(pair)) {
            return node;
        }
        if (node.children != null) {
            Node node2;
            Iterator iterator = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(iterator)) != null) {
                Node node3 = InheritanceTree.removeClass(node2, pair);
                if ((node2.items == null || node2.items.isEmpty()) && (node2.children == null || node2.children.isEmpty())) {
                    iterator.remove();
                }
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    private Node classToNode(Node node, Class clazz) {
        Object object;
        if (!node.accepts(clazz)) {
            return null;
        }
        if (node.getType() == clazz) {
            return node;
        }
        if (node.children != null) {
            Node node2;
            object = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(object)) != null) {
                Node node3 = this.classToNode(node2, clazz);
                if (node3 != null && node2.deserialized()) {
                    class VerifyJob
                    implements AbstractLookup.ISE.Job {
                        private AbstractLookup.Pair[] pairs;
                        private boolean[] answers;
                        private final /* synthetic */ Node val$ch;
                        private final /* synthetic */ Class val$clazz;
                        private final /* synthetic */ Node val$n;

                        public VerifyJob(Collection collection, Node node, Class clazz, Node node2) {
                            this.val$ch = node;
                            this.val$clazz = clazz;
                            this.val$n = node2;
                            if (collection != null) {
                                this.pairs = collection.toArray(new AbstractLookup.Pair[0]);
                            }
                        }

                        public void before() {
                            this.val$ch.deserialized();
                            if (this.pairs != null) {
                                this.answers = new boolean[this.pairs.length];
                                for (int i = 0; i < this.pairs.length; ++i) {
                                    this.answers[i] = this.pairs[i].instanceOf(this.val$clazz);
                                }
                            }
                        }

                        public void inside() {
                            if (this.pairs != null) {
                                for (int i = 0; i < this.pairs.length; ++i) {
                                    if (!this.answers[i]) continue;
                                    this.val$ch.assignItem(InheritanceTree.this, this.pairs[i]);
                                    this.val$n.items.remove(this.pairs[i]);
                                }
                            }
                            if (this.val$n.children != null) {
                                HashMap<Class, Node> hashMap = new HashMap<Class, Node>(this.val$n.children.size() * 3);
                                Iterator iterator = this.val$n.children.iterator();
                                while (iterator.hasNext()) {
                                    Node node = InheritanceTree.extractNode(iterator);
                                    Node node2 = hashMap.put(node.getType(), node);
                                    if (node2 == null) continue;
                                    iterator.remove();
                                    hashMap.put(node.getType(), node2);
                                    node2.markDeserialized();
                                    if (node2.children == null) {
                                        node2.children = node.children;
                                    } else if (node.children != null) {
                                        node2.children.addAll(node.children);
                                    }
                                    if (node.items == null) continue;
                                    Iterator iterator2 = node.items.iterator();
                                    while (iterator2.hasNext()) {
                                        AbstractLookup.Pair pair = (AbstractLookup.Pair)iterator2.next();
                                        node2.assignItem(InheritanceTree.this, pair);
                                    }
                                }
                            }
                        }
                    }
                    VerifyJob verifyJob = new VerifyJob(node.items, node2, clazz, node);
                    try {
                        verifyJob.before();
                    }
                    catch (AbstractLookup.ISE iSE) {
                        node2.markDeserialized();
                        iSE.registerJob(verifyJob);
                        throw iSE;
                    }
                    verifyJob.inside();
                    node3 = this.classToNode(node2, clazz);
                }
                if (node3 == null) continue;
                return node3;
            }
        }
        class TwoJobs
        implements AbstractLookup.ISE.Job {
            private AbstractLookup.Pair[] pairs;
            private boolean[] answers;
            private Node newNode;
            private final /* synthetic */ Node val$n;
            private final /* synthetic */ Class val$clazz;

            TwoJobs(Node node, Class clazz) {
                this.val$n = node;
                this.val$clazz = clazz;
            }

            public void before() {
                AbstractLookup.Pair[] pairArray = null;
                boolean[] blArray = null;
                if (this.val$n.items != null) {
                    pairArray = new AbstractLookup.Pair[this.val$n.items.size()];
                    blArray = new boolean[this.val$n.items.size()];
                    int n = 0;
                    Iterator iterator = this.val$n.items.iterator();
                    while (iterator.hasNext()) {
                        AbstractLookup.Pair pair;
                        pairArray[n] = pair = (AbstractLookup.Pair)iterator.next();
                        blArray[n] = pair.instanceOf(this.val$clazz);
                        ++n;
                    }
                }
                this.pairs = pairArray;
                this.answers = blArray;
            }

            public void inside() {
                if (this.pairs != null && !Arrays.equals(this.val$n.items.toArray(), this.pairs)) {
                    return;
                }
                this.internal();
            }

            public void internal() {
                Iterator iterator;
                ArrayList<Node> arrayList = null;
                if (this.val$n.children == null) {
                    this.val$n.children = new ArrayList();
                } else {
                    Node node;
                    iterator = this.val$n.children.iterator();
                    while ((node = InheritanceTree.extractNode(iterator)) != null) {
                        if (!this.val$clazz.isAssignableFrom(node.getType())) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<Node>();
                        }
                        arrayList.add(node);
                        iterator.remove();
                    }
                }
                this.newNode = new Node(this.val$clazz);
                this.val$n.children.add(this.newNode);
                if (arrayList != null) {
                    this.newNode.children = arrayList;
                }
                if (this.val$n.items != null) {
                    iterator = this.val$n.items.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        AbstractLookup.Pair pair = (AbstractLookup.Pair)iterator.next();
                        if (this.answers[n]) {
                            iterator.remove();
                            this.newNode.assignItem(InheritanceTree.this, this.pairs[n]);
                        }
                        ++n;
                    }
                }
            }
        }
        object = new TwoJobs(node, clazz);
        try {
            ((TwoJobs)object).before();
        }
        catch (AbstractLookup.ISE iSE) {
            iSE.registerJob((AbstractLookup.ISE.Job)object);
            throw iSE;
        }
        ((TwoJobs)object).internal();
        return ((TwoJobs)object).newNode;
    }

    private Enumeration searchClass(Node node, Class clazz) {
        if (clazz != null) {
            node = this.classToNode(node, clazz);
        }
        if (node == null) {
            return Enumerations.empty();
        }
        return InheritanceTree.nodeToEnum(node);
    }

    private boolean retainAllClasses(Node node, Map map, Collection collection) {
        Serializable serializable;
        Iterator iterator;
        boolean bl = false;
        if (node.items != null && map != null) {
            iterator = node.items.iterator();
            while (iterator.hasNext()) {
                serializable = (AbstractLookup.Pair)iterator.next();
                AbstractLookup.Info info = (AbstractLookup.Info)map.remove(serializable);
                if (info == null) {
                    iterator.remove();
                    bl = true;
                    continue;
                }
                if (((AbstractLookup.Pair)serializable).getIndex() == info.index) continue;
                ((AbstractLookup.Pair)serializable).setIndex(null, info.index);
            }
            if (bl && collection != null) {
                collection.add(node.getType());
            }
        }
        if (node.children != null) {
            iterator = node.children.iterator();
            while ((serializable = InheritanceTree.extractNode(iterator)) != null) {
                boolean bl2 = this.retainAllClasses((Node)serializable, map, collection);
                if (!bl2) continue;
                iterator.remove();
            }
        }
        return bl && node.items.isEmpty() && (node.children == null || node.children.isEmpty());
    }

    private static Enumeration nodeToEnum(Node node) {
        if (node.children == null) {
            return node.items == null ? Enumerations.empty() : Collections.enumeration(node.items);
        }
        class DeepAndItems
        implements Enumerations.Processor {
            DeepAndItems() {
            }

            public Object process(Object object, Collection collection) {
                Node node = (Node)object;
                if (node.children != null) {
                    collection.addAll(node.children);
                }
                if (node.items == null || node.items.isEmpty()) {
                    return Enumerations.empty();
                }
                return Collections.enumeration(node.items);
            }
        }
        Enumeration enumeration = Enumerations.queue(Enumerations.singleton(node), new DeepAndItems());
        return new NeedsSortEnum(Enumerations.concat(enumeration));
    }

    private boolean registerInterface(AbstractLookup.Pair pair, Collection collection) {
        if (this.interfaces == null) {
            return true;
        }
        Iterator iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<AbstractLookup.Pair> arrayList;
            Map.Entry entry = iterator.next();
            Class clazz = (Class)entry.getKey();
            if (!pair.instanceOf(clazz)) continue;
            Object v = entry.getValue();
            if (v instanceof Collection) {
                arrayList = (ArrayList<AbstractLookup.Pair>)v;
                if (!arrayList.add(pair)) {
                    return false;
                }
            } else {
                if (v.equals(pair)) {
                    return false;
                }
                arrayList = new ArrayList<AbstractLookup.Pair>(3);
                arrayList.add((AbstractLookup.Pair)v);
                arrayList.add(pair);
                entry.setValue(arrayList);
            }
            collection.add(clazz);
        }
        return true;
    }

    private void removeInterface(AbstractLookup.Pair pair, Collection collection) {
        if (this.interfaces == null) {
            return;
        }
        Iterator iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v instanceof Collection) {
                Collection collection2 = (Collection)v;
                if (!collection2.remove(pair)) continue;
                if (collection2.size() == 1) {
                    entry.setValue(collection2.iterator().next());
                }
                collection.add(entry.getKey());
                continue;
            }
            if (!v.equals(pair)) continue;
            iterator.remove();
            collection.add(entry.getKey());
        }
    }

    private void retainAllInterface(Map map, Collection collection) {
        if (this.interfaces == null) {
            return;
        }
        Iterator iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            HashMap hashMap = new HashMap(map);
            boolean bl = v instanceof Collection;
            Iterator<Object> iterator2 = bl ? ((Collection)v).iterator() : Collections.singleton(v).iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator2.hasNext()) {
                object = (AbstractLookup.Pair)iterator2.next();
                AbstractLookup.Info info = (AbstractLookup.Info)hashMap.remove(object);
                if (info == null) {
                    if (bl) {
                        iterator2.remove();
                    }
                    bl2 = true;
                    continue;
                }
                if (((AbstractLookup.Pair)object).getIndex() == info.index) continue;
                ((AbstractLookup.Pair)object).setIndex(null, info.index);
                bl3 = true;
            }
            if (bl3 && v instanceof List) {
                object = (List)v;
                Collections.sort(object, ALPairComparator.DEFAULT);
            }
            if (!bl2) continue;
            if (bl) {
                object = (Collection)v;
                if (object.size() == 1) {
                    entry.setValue(object.iterator().next());
                }
            } else {
                iterator.remove();
            }
            collection.add(entry.getKey());
        }
    }

    private Enumeration searchInterface(Class clazz) {
        Object v;
        if (this.interfaces == null) {
            this.interfaces = new WeakHashMap();
        }
        if ((v = this.interfaces.get(clazz)) == null) {
            AbstractLookup.Pair pair = null;
            ArrayList<AbstractLookup.Pair> arrayList = null;
            Enumeration enumeration = this.lookup(Object.class);
            while (enumeration.hasMoreElements()) {
                AbstractLookup.Pair pair2 = (AbstractLookup.Pair)enumeration.nextElement();
                if (!pair2.instanceOf(clazz)) continue;
                if (pair == null) {
                    pair = pair2;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList(3);
                    arrayList.add(pair);
                }
                arrayList.add(pair2);
            }
            if (arrayList == null && pair != null) {
                this.interfaces.put(clazz, pair);
                return Enumerations.singleton(pair);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<AbstractLookup.Pair>(2);
            }
            this.interfaces.put(clazz, arrayList);
            return Collections.enumeration(arrayList);
        }
        if (v instanceof Collection) {
            return Collections.enumeration((Collection)v);
        }
        return Enumerations.singleton(v);
    }

    private static Node extractNode(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.get() == null) {
                iterator.remove();
                continue;
            }
            return node;
        }
        return null;
    }

    private static void printNode(Node node, String string, PrintStream printStream, boolean bl) {
        Serializable serializable;
        Iterator iterator;
        int n;
        Class clazz = node.getType();
        printStream.print(string);
        printStream.println("Node for: " + clazz + "\t" + (clazz == null ? null : clazz.getClassLoader()));
        if (node.items != null) {
            n = 0;
            iterator = new ArrayList(node.items).iterator();
            while (iterator.hasNext()) {
                serializable = (AbstractLookup.Pair)iterator.next();
                printStream.print(string);
                printStream.print("  item (" + n++ + "): ");
                printStream.print(serializable);
                printStream.print(" id: " + Integer.toHexString(System.identityHashCode(serializable)));
                printStream.print(" index: ");
                printStream.print(((AbstractLookup.Pair)serializable).getIndex());
                if (bl) {
                    printStream.print(" I: " + ((Lookup.Item)((Object)serializable)).getInstance());
                }
                printStream.println();
            }
        }
        if (node.children != null) {
            n = 0;
            iterator = node.children.iterator();
            while (iterator.hasNext()) {
                serializable = (Node)iterator.next();
                InheritanceTree.printNode((Node)serializable, string + "  ", printStream, bl);
            }
        }
    }

    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult referenceToResult) {
        if (this.reg == null) {
            this.reg = new HashMap();
        }
        Class clazz = referenceToResult.template.getType();
        this.lookup(clazz);
        return this.reg.put(clazz, referenceToResult);
    }

    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template template) {
        this.collectListeners(null, template.getType());
        return this.reg == null ? null : (AbstractLookup.ReferenceToResult)this.reg.get(template.getType());
    }

    public Object beginTransaction(int n) {
        return new ArrayList();
    }

    public void endTransaction(Object object, Set set) {
        ArrayList arrayList = (ArrayList)object;
        if (arrayList.size() == 1) {
            this.collectListeners(set, (Class)arrayList.get(0));
        } else {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.collectListeners(set, (Class)iterator.next());
            }
        }
    }

    private void collectListeners(Set set, Class clazz) {
        if (this.reg == null) {
            return;
        }
        while (clazz != null) {
            AbstractLookup.ReferenceToResult referenceToResult = (AbstractLookup.ReferenceToResult)this.reg.get(clazz);
            AbstractLookup.ReferenceIterator referenceIterator = new AbstractLookup.ReferenceIterator(referenceToResult);
            while (referenceIterator.next()) {
                AbstractLookup.R r = referenceIterator.current().getResult();
                if (set == null) continue;
                set.add(r);
            }
            if (referenceToResult != referenceIterator.first()) {
                if (referenceIterator.first() == null) {
                    this.reg.remove(clazz);
                } else {
                    this.reg.put(clazz, referenceIterator.first());
                }
            }
            clazz = clazz.getSuperclass();
        }
        if (this.reg.isEmpty()) {
            this.reg = null;
        }
    }

    private static final class NeedsSortEnum
    implements Enumeration {
        private Enumeration en;

        public NeedsSortEnum(Enumeration enumeration) {
            this.en = enumeration;
        }

        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        public Object nextElement() {
            return this.en.nextElement();
        }
    }

    private static final class R
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static ClassLoader l;
        private String clazzName;
        private transient Class clazz;
        private ArrayList children;
        private ArrayList items;

        public R(Node node) {
            this.clazzName = node.getType().getName();
            this.children = node.children;
            this.items = node.items instanceof ArrayList || node.items == null ? (ArrayList)node.items : new ArrayList(node.items);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (l == null) {
                l = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = InheritanceTree.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            }
            this.clazz = Class.forName(this.clazzName, false, l);
        }

        private Object readResolve() throws ObjectStreamException {
            Node node = new Node(this.clazz);
            node.children = this.children;
            node.items = this.items;
            node.markDeserialized();
            return node;
        }
    }

    static final class Node
    extends WeakReference
    implements Serializable {
        static final long serialVersionUID = 3L;
        public ArrayList children;
        public List items;

        public Node(Class clazz) {
            super(clazz);
        }

        public boolean deserialized() {
            if (this.items == null || this.items instanceof ArrayList) {
                return false;
            }
            this.items = this.items.isEmpty() ? null : new ArrayList(this.items);
            return true;
        }

        public void markDeserialized() {
            this.items = this.items == null ? Collections.EMPTY_LIST : Collections.synchronizedList(this.items);
        }

        public Class getType() {
            Class clazz = (Class)this.get();
            return clazz == null ? Void.TYPE : clazz;
        }

        public boolean accepts(Class clazz) {
            if (this.getType() == (class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object)) {
                return true;
            }
            return this.getType().isAssignableFrom(clazz);
        }

        public boolean accepts(AbstractLookup.Pair pair) {
            if (this.getType() == (class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object)) {
                return true;
            }
            return pair.instanceOf(this.getType());
        }

        public boolean assignItem(InheritanceTree inheritanceTree, AbstractLookup.Pair pair) {
            if (this.items == null || this.items == Collections.EMPTY_LIST) {
                this.items = new ArrayList();
                this.items.add(pair);
                return true;
            }
            if (this.items.contains(pair)) {
                int n = this.items.indexOf(pair);
                AbstractLookup.Pair pair2 = (AbstractLookup.Pair)this.items.get(n);
                if (pair2 != pair) {
                    pair.setIndex(inheritanceTree, pair2.getIndex());
                }
                this.items.remove(pair2);
                this.items.add(pair);
                return false;
            }
            this.items.add(pair);
            return true;
        }

        private Object writeReplace() {
            return new R(this);
        }

        public String toString() {
            return "Node for " + this.get();
        }
    }
}

