/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.udf;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.Tuple;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class ReadScalarsTez
extends EvalFunc<Object>
implements TezInput {
    private static final Log LOG = LogFactory.getLog(ReadScalarsTez.class);
    private String inputKey;
    private transient Tuple t;
    private transient LogicalInput input;

    public ReadScalarsTez(String inputKey) {
        this.inputKey = inputKey;
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.inputKey)) {
            this.inputKey = newInputKey;
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
        String cacheKey = "scalar-" + this.inputKey;
        Object cacheValue = ObjectCache.getInstance().retrieve(cacheKey);
        if (cacheValue != null) {
            inputsToSkip.add(this.inputKey);
        }
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        String cacheKey = "scalar-" + this.inputKey;
        Object cacheValue = ObjectCache.getInstance().retrieve(cacheKey);
        if (cacheValue != null) {
            this.t = (Tuple)cacheValue;
            return;
        }
        this.input = inputs.get(this.inputKey);
        if (this.input == null) {
            throw new ExecException("Input from vertex " + this.inputKey + " is missing");
        }
        try {
            KeyValueReader reader = (KeyValueReader)this.input.getReader();
            if (reader.next()) {
                String first;
                this.t = (Tuple)reader.getCurrentValue();
                String string = first = this.t == null ? null : this.t.toString();
                if (reader.next()) {
                    String msg = "Scalar has more than one row in the output. 1st : " + first + ", 2nd :" + reader.getCurrentValue() + " (common cause: \"JOIN\" then \"FOREACH ... GENERATE foo.bar\" should be \"foo::bar\" )";
                    throw new ExecException(msg);
                }
            } else {
                LOG.info((Object)("Scalar input from vertex " + this.inputKey + " is null"));
            }
            LOG.info((Object)("Attached input from vertex " + this.inputKey + " : input=" + this.input + ", reader=" + reader));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
        ObjectCache.getInstance().cache(cacheKey, this.t);
        this.log.info((Object)("Cached scalar in Tez ObjectRegistry with vertex scope. cachekey=" + cacheKey));
    }

    @Override
    public Object exec(Tuple input) throws IOException {
        if (this.t == null) {
            return null;
        }
        int pos = (Integer)input.get(0);
        Object obj = this.t.get(pos);
        return obj;
    }
}

