/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;

public class OperatorSubPlan
implements OperatorPlan {
    private OperatorPlan basePlan;
    private List<Operator> roots;
    private List<Operator> leaves;
    private Set<Operator> operators;

    public OperatorSubPlan(OperatorPlan base) {
        this.basePlan = base;
        this.roots = new ArrayList<Operator>();
        this.leaves = new ArrayList<Operator>();
        this.operators = new HashSet<Operator>();
    }

    public OperatorPlan getBasePlan() {
        return this.basePlan;
    }

    @Override
    public void add(Operator op) {
        this.operators.add(op);
        this.leaves.clear();
        this.roots.clear();
    }

    @Override
    public void connect(Operator from, int fromPos, Operator to, int toPos) {
        throw new UnsupportedOperationException("connect() can not be called on OperatorSubPlan");
    }

    @Override
    public void connect(Operator from, Operator to) {
        throw new UnsupportedOperationException("connect() can not be called on OperatorSubPlan");
    }

    @Override
    public Pair<Integer, Integer> disconnect(Operator from, Operator to) throws FrontendException {
        throw new UnsupportedOperationException("disconnect() can not be called on OperatorSubPlan");
    }

    @Override
    public List<Operator> getSinks() {
        if (this.leaves.size() == 0 && this.operators.size() > 0) {
            for (Operator op : this.operators) {
                if (this.getSuccessors(op) != null) continue;
                this.leaves.add(op);
            }
        }
        return this.leaves;
    }

    @Override
    public Iterator<Operator> getOperators() {
        return this.operators.iterator();
    }

    @Override
    public List<Operator> getPredecessors(Operator op) {
        List<Operator> l = this.basePlan.getPredecessors(op);
        ArrayList<Operator> list = null;
        if (l != null) {
            for (Operator oper : l) {
                if (!this.operators.contains(oper)) continue;
                if (list == null) {
                    list = new ArrayList<Operator>();
                }
                list.add(oper);
            }
        }
        return list;
    }

    @Override
    public List<Operator> getSources() {
        if (this.roots.size() == 0 && this.operators.size() > 0) {
            for (Operator op : this.operators) {
                if (this.getPredecessors(op) != null) continue;
                this.roots.add(op);
            }
        }
        return this.roots;
    }

    @Override
    public List<Operator> getSuccessors(Operator op) {
        List<Operator> l = this.basePlan.getSuccessors(op);
        ArrayList<Operator> list = null;
        if (l != null) {
            for (Operator oper : l) {
                if (!this.operators.contains(oper)) continue;
                if (list == null) {
                    list = new ArrayList<Operator>();
                }
                list.add(oper);
            }
        }
        return list;
    }

    @Override
    public void remove(Operator op) throws FrontendException {
        this.operators.remove(op);
        this.leaves.clear();
        this.roots.clear();
    }

    @Override
    public int size() {
        return this.operators.size();
    }

    @Override
    public boolean isEqual(OperatorPlan other) throws FrontendException {
        return BaseOperatorPlan.isEqual(this, other);
    }

    @Override
    public void createSoftLink(Operator from, Operator to) {
        throw new UnsupportedOperationException("connect() can not be called on OperatorSubPlan");
    }

    @Override
    public void removeSoftLink(Operator from, Operator to) {
        throw new UnsupportedOperationException("removeSoftLink() can not be called on OperatorSubPlan");
    }

    @Override
    public List<Operator> getSoftLinkPredecessors(Operator op) {
        return this.basePlan.getSoftLinkPredecessors(op);
    }

    @Override
    public List<Operator> getSoftLinkSuccessors(Operator op) {
        return this.basePlan.getSoftLinkSuccessors(op);
    }

    @Override
    public void insertBetween(Operator pred, Operator operatorToInsert, Operator succ) throws FrontendException {
        throw new UnsupportedOperationException("insertBetween() can not be called on OperatorSubPlan");
    }

    @Override
    public void removeAndReconnect(Operator operatorToRemove) throws FrontendException {
        throw new UnsupportedOperationException("removeAndReconnect() can not be called on OperatorSubPlan");
    }

    @Override
    public void replace(Operator oldOperator, Operator newOperator) throws FrontendException {
        throw new UnsupportedOperationException("replace() can not be called on OperatorSubPlan");
    }

    @Override
    public boolean pathExists(Operator from, Operator to) {
        return false;
    }
}

