/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int INSET = 1;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    @Override
    Rectangle computeTrim(Theme theme, GC gC) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = this.clientArea.x;
            rECT.right = this.clientArea.x + this.clientArea.width;
            rECT.top = this.clientArea.y;
            rECT.bottom = this.clientArea.y + this.clientArea.height;
            RECT rECT2 = new RECT();
            int[] nArray = this.getPartId(0);
            OS.GetThemeBackgroundExtent(l, gC.handle, nArray[0], nArray[1], rECT, rECT2);
            OS.CloseThemeData(l);
            if ((this.style & 4) != 0) {
                SIZE sIZE = new SIZE();
                nArray = this.getPartId(1);
                OS.GetThemePartSize(l, 0L, nArray[0], nArray[1], null, 1, sIZE);
                rECT2.right = Math.max(rECT2.left, rECT2.right + sIZE.cx);
            } else {
                --rECT2.left;
                --rECT2.top;
                ++rECT2.right;
                ++rECT2.bottom;
            }
            return new Rectangle(rECT2.left, rECT2.top, rECT2.right - rECT2.left, rECT2.bottom - rECT2.top);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rectangle.y + rectangle.height;
            SIZE sIZE = null;
            int[] nArray = null;
            if ((this.style & 4) != 0) {
                sIZE = new SIZE();
                nArray = this.getPartId(1);
                OS.GetThemePartSize(l, gC.handle, nArray[0], nArray[1], rECT, 1, sIZE);
                rECT.right -= sIZE.cx;
                if (rECT.right < rECT.left) {
                    rECT.right = rECT.left;
                }
            }
            int[] nArray2 = this.getPartId(0);
            OS.DrawThemeBackground(l, gC.handle, nArray2[0], nArray2[1], rECT, null);
            Rectangle rectangle2 = this.clientArea;
            if (rectangle2 != null) {
                RECT rECT2 = new RECT();
                OS.GetThemeBackgroundContentRect(l, gC.handle, nArray2[0], nArray2[1], rECT, rECT2);
                rectangle2.x = rECT2.left;
                rectangle2.y = rECT2.top;
                rectangle2.width = rECT2.right - rECT2.left;
                rectangle2.height = rECT2.bottom - rECT2.top;
            }
            if ((this.style & 4) != 0) {
                rECT.left = rECT.right;
                rECT.right = rECT.left + sIZE.cx;
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            }
            OS.CloseThemeData(l);
        }
    }

    @Override
    char[] getClassId() {
        return TOOLBAR;
    }

    @Override
    int[] getPartId(int n) {
        int n2 = this.state[n];
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                if ((this.style & 0x38) != 0) {
                    n3 = 1;
                } else if ((this.style & 4) != 0) {
                    n3 = 3;
                } else if ((this.style & 2) != 0) {
                    n3 = (this.parent.style & 0x200) != 0 ? 6 : 5;
                }
                if ((this.style & 2) != 0) break;
                if ((n2 & 0x40) != 0) {
                    n4 = (this.style & 0x30) != 0 && (n2 & 2) != 0 ? 6 : 2;
                }
                if ((this.style & 0x30) != 0 && (n2 & 2) != 0) {
                    n4 = 5;
                }
                if ((n2 & 8) != 0) {
                    n4 = 3;
                }
                if ((n2 & 0x20) == 0) break;
                n4 = 4;
                break;
            }
            case 1: {
                n3 = 4;
                if ((n2 & 0x40) != 0) {
                    n4 = 2;
                }
                if ((n2 & 8) != 0) {
                    n4 = 3;
                }
                if ((n2 & 0x20) == 0) break;
                n4 = 4;
            }
        }
        return new int[]{n3, n4};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return -1;
        }
        if (!rectangle.contains(point)) {
            return -1;
        }
        long l = OS.OpenThemeData(0L, this.getClassId());
        try {
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rectangle.y + rectangle.height;
            POINT pOINT = new POINT();
            pOINT.x = point.x;
            pOINT.y = point.y;
            short[] sArray = new short[1];
            int[] nArray = this.getPartId(0);
            OS.HitTestThemeBackground(l, 0L, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
            if (sArray[0] == 0) {
                int n = -1;
                return n;
            }
            int n = this.style;
            if ((n & 4) != 0) {
                SIZE sIZE = new SIZE();
                nArray = this.getPartId(1);
                OS.GetThemePartSize(l, 0L, nArray[0], nArray[1], rECT, 1, sIZE);
                rECT.left = Math.max(rECT.left, rECT.right - sIZE.cx);
                OS.HitTestThemeBackground(l, 0L, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    int n2 = 1;
                    return n2;
                }
            }
        }
        finally {
            OS.CloseThemeData(l);
        }
        return 0;
    }
}

