/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingPlugin;
import org.pentaho.di.core.logging.LoggingPluginInterface;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=LoggingPluginInterface.class)
@PluginAnnotationType(value=LoggingPlugin.class)
public class LoggingPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static LoggingPluginType loggingPluginType;

    private LoggingPluginType() {
        super(LoggingPlugin.class, "LOGGING", "Logging Plugin");
        this.populateFolders("logging");
    }

    public static LoggingPluginType getInstance() {
        if (loggingPluginType == null) {
            loggingPluginType = new LoggingPluginType();
        }
        return loggingPluginType;
    }

    @Override
    protected void registerNatives() throws KettlePluginException {
        String kettleLoggingPluginsXmlFile = "kettle-logging-plugins.xml";
        String alternative = System.getProperty("KETTLE_LOGGING_PLUGINS_FILE", null);
        if (!Utils.isEmpty(alternative)) {
            kettleLoggingPluginsXmlFile = alternative;
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(kettleLoggingPluginsXmlFile);
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + kettleLoggingPluginsXmlFile);
            }
            if (inputStream == null && !Utils.isEmpty(alternative)) {
                try {
                    inputStream = new FileInputStream(kettleLoggingPluginsXmlFile);
                }
                catch (Exception e) {
                    throw new KettlePluginException("Unable to load native logging plugins '" + kettleLoggingPluginsXmlFile + "'", e);
                }
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native logging plugins definition file: kettle-logging-plugins.xml");
            }
            Document document = XMLHandler.loadXMLFile(inputStream, null, true, false);
            Node stepsNode = XMLHandler.getSubNode(document, "logging-plugins");
            List<Node> stepNodes = XMLHandler.getNodes(stepsNode, "logging-plugin");
            for (Node stepNode : stepNodes) {
                this.registerPluginFromXmlResource(stepNode, null, this.getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle logging plugins XML config file: " + kettleLoggingPluginsXmlFile, e);
        }
    }

    @Override
    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List<FileObject> pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile(file);
                    Node pluginNode = XMLHandler.getSubNode(document, "plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename(file.getParent()), this.getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading logging plugin.xml file: " + file.getName().toString(), e);
                }
            }
        }
    }

    @Override
    protected String extractCategory(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractDesc(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractID(Annotation annotation) {
        String id = ((LoggingPlugin)annotation).id();
        return id;
    }

    @Override
    protected String extractName(Annotation annotation) {
        String name = ((LoggingPlugin)annotation).name();
        return Utils.isEmpty(name) ? this.extractID(annotation) : name;
    }

    @Override
    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    @Override
    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((LoggingPlugin)annotation).isSeparateClassLoaderNeeded();
    }

    @Override
    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    @Override
    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    @Override
    protected String extractDocumentationUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractCasesUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractForumUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((LoggingPlugin)annotation).classLoaderGroup();
    }
}

