/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.pentaho.metaverse.api.ILineageCollector;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.DateRangeFolderFilenameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemLineageCollector
implements ILineageCollector {
    public static final String DEFAULT_OUTPUT_FOLDER = ".";
    private String outputFolder = ".";
    private static final Logger log = LoggerFactory.getLogger(FileSystemLineageCollector.class);
    protected SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

    public FileSystemLineageCollector() {
        this.format.setLenient(false);
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public List<String> listArtifacts() throws IllegalArgumentException {
        return this.listArtifacts(null, null);
    }

    public List<String> listArtifacts(String startingDate) throws IllegalArgumentException {
        return this.listArtifacts(startingDate, null);
    }

    public List<String> listArtifacts(String startingDate, String endingDate) throws IllegalArgumentException {
        File lineageRootFolder = new File(this.getOutputFolder());
        ArrayList<String> paths = new ArrayList<String>();
        DateRangeFolderFilenameFilter filter = new DateRangeFolderFilenameFilter(this.format, startingDate, endingDate);
        if (lineageRootFolder.exists() && lineageRootFolder.isDirectory()) {
            String[] dayFolders;
            for (String dayFolder : dayFolders = lineageRootFolder.list(filter)) {
                File listThisFolder = new File(lineageRootFolder, dayFolder);
                Collection files = FileUtils.listFiles((File)listThisFolder, null, (boolean)true);
                paths.addAll(this.sanitizePaths(files));
            }
        }
        return paths;
    }

    public List<String> listArtifactsForFile(String pathToArtifact) throws IllegalArgumentException {
        return this.listArtifactsForFile(pathToArtifact, null);
    }

    public List<String> listArtifactsForFile(String pathToArtifact, String startingDate) {
        return this.listArtifactsForFile(pathToArtifact, startingDate, null);
    }

    public List<String> listArtifactsForFile(String pathToArtifact, String startingDate, String endingDate) throws IllegalArgumentException {
        File lineageRootFolder = new File(this.getOutputFolder());
        ArrayList<String> paths = new ArrayList<String>();
        DateRangeFolderFilenameFilter filter = new DateRangeFolderFilenameFilter(this.format, startingDate, endingDate);
        if (lineageRootFolder.exists() && lineageRootFolder.isDirectory()) {
            String[] dayFolders;
            for (String dayFolder : dayFolders = lineageRootFolder.list(filter)) {
                File listThisFolder = new File(lineageRootFolder, dayFolder);
                File requested = new File(listThisFolder, pathToArtifact);
                if (!requested.exists() || !requested.isDirectory()) continue;
                Collection files = FileUtils.listFiles((File)requested, null, (boolean)true);
                paths.addAll(this.sanitizePaths(files));
            }
        }
        return paths;
    }

    protected List<String> sanitizePaths(Collection<File> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            String path = file.getPath();
            if (path.startsWith("./")) {
                path = path.substring(2);
            }
            paths.add(path);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressArtifacts(List<String> paths, OutputStream os) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(os);
            for (String path : paths) {
                File file = new File(path);
                try {
                    ZipEntry zipEntry = new ZipEntry(file.getPath());
                    zos.putNextEntry(zipEntry);
                    FileInputStream fis = new FileInputStream(file);
                    zos.write(IOUtils.toByteArray((InputStream)fis));
                }
                catch (IOException e) {
                    log.error(Messages.getString("ERROR.FailedAddingFileToZip", file.getPath()));
                }
                finally {
                    try {
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        log.error(Messages.getString("ERROR.FailedToProperlyCloseZipEntry", file.getPath()));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }
}

