/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.locator;

import java.io.File;
import org.pentaho.metaverse.locator.LocatorRunner;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemLocatorRunner
extends LocatorRunner<File> {
    private static final Logger LOG = LoggerFactory.getLogger(LocatorRunner.class);

    @Override
    public void locate(File folder) {
        File[] files;
        for (File file : files = folder.listFiles()) {
            if (this.stopping) {
                return;
            }
            if (!file.isDirectory()) {
                try {
                    if (file.isHidden()) continue;
                    this.processFile(this.locator.getNamespace(), file.getName(), file.getCanonicalPath(), file);
                }
                catch (Exception e) {
                    LOG.error(Messages.getString("ERROR.ProcessFileFailed", file.getName()), (Throwable)e);
                }
                continue;
            }
            this.locate(file);
        }
    }
}

