/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.webjars;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.pentaho.js.require.RequireJsGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebjarsURLConnection
extends URLConnection {
    public static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(5, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("WebjarsURLConnection pool");
            return thread;
        }
    });
    public Future<Void> transform_thread;
    private static final String DEBUG_MESSAGE_FAILED_WRITING = "Problem transfering Jar content, probably JarOutputStream was already closed.";
    private static final String MANIFEST_MF = "MANIFEST.MF";
    private static final String PENTAHO_RJS_LOCATION = "META-INF/js/require.json";
    private static final String WEBJARS_REQUIREJS_NAME = "webjars-requirejs.js";
    private static final Pattern MODULE_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/webjars-requirejs.js");
    private static final String POM_NAME = "pom.xml";
    private static final Pattern POM_PATTERN = Pattern.compile("META-INF/maven/org.webjars([^/]*)/([^/]+)/pom.xml");
    private static final String BOWER_NAME = "bower.json";
    private static final Pattern BOWER_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/bower.json");
    private static final String NPM_NAME = "package.json";
    private static final Pattern NPM_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/package.json");
    private static final Pattern PACKAGE_FILES_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/.*");
    private static final Pattern PACKAGE_JS_FILES_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/.*\\.js");
    private static final ArrayList<String> JS_KNOWN_GLOBALS = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public WebjarsURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            final PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            this.transform_thread = EXECUTOR.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        WebjarsURLConnection.this.transform(WebjarsURLConnection.this.getURL(), pipedOutputStream);
                    }
                    catch (Exception e) {
                        WebjarsURLConnection.this.logger.error("Error Transforming zip", (Throwable)e);
                        pipedOutputStream.close();
                        throw e;
                    }
                    return null;
                }
            });
            return pipedInputStream;
        }
        catch (Exception e) {
            this.logger.error("Error opening Spring xml url", (Throwable)e);
            throw (IOException)new IOException("Error opening Spring xml url").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(URL url, PipedOutputStream pipedOutputStream) throws IOException {
        RequireJsGenerator.ArtifactInfo artifactInfo = new RequireJsGenerator.ArtifactInfo(url);
        boolean isClassicWebjar = artifactInfo.getGroup().equals("org.webjars");
        boolean wasReadFromPom = false;
        boolean isNpmWebjar = artifactInfo.getGroup().equals("org.webjars.npm");
        boolean isBowerWebjar = artifactInfo.getGroup().equals("org.webjars.bower");
        ArrayList<String> exportedGlobals = new ArrayList<String>();
        boolean isAmdPackage = this.findAmdDefine(url, exportedGlobals);
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        InputStream inputStream = urlConnection.getInputStream();
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        try {
            JarEntry entry;
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)pipedOutputStream, this.getManifest(artifactInfo, jarInputStream));
            RequireJsGenerator requireConfig = null;
            String physicalPathNamePart = null;
            String physicalPathVersionPart = null;
            String bowerVersion = null;
            while ((entry = jarInputStream.getNextJarEntry()) != null) {
                Matcher matcher;
                String name = entry.getName();
                if (name.endsWith(MANIFEST_MF)) continue;
                if (requireConfig == null || isClassicWebjar && !wasReadFromPom || isBowerWebjar && bowerVersion == null) {
                    if (isClassicWebjar) {
                        if (name.endsWith(POM_NAME)) {
                            matcher = POM_PATTERN.matcher(name);
                            if (matcher.matches()) {
                                try {
                                    requireConfig = RequireJsGenerator.parsePom((InputStream)jarInputStream);
                                    wasReadFromPom = true;
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                        } else if (name.endsWith(WEBJARS_REQUIREJS_NAME) && (matcher = MODULE_PATTERN.matcher(name)).matches()) {
                            try {
                                requireConfig = RequireJsGenerator.processJsScript((String)matcher.group(1), (String)matcher.group(2), (InputStream)jarInputStream);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    } else if (isNpmWebjar && name.endsWith(NPM_NAME) || isBowerWebjar && name.endsWith(BOWER_NAME)) {
                        Matcher matcher2 = matcher = isNpmWebjar ? NPM_PATTERN.matcher(name) : BOWER_PATTERN.matcher(name);
                        if (matcher.matches()) {
                            try {
                                requireConfig = RequireJsGenerator.parseJsonPackage((InputStream)jarInputStream);
                                if (!isBowerWebjar || requireConfig == null || requireConfig.getModuleInfo() == null) continue;
                                if (requireConfig.getModuleInfo().getVersion() == null && bowerVersion != null) {
                                    requireConfig.getModuleInfo().setVersion(bowerVersion);
                                    continue;
                                }
                                bowerVersion = requireConfig.getModuleInfo().getVersion();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    } else if (isBowerWebjar && name.endsWith(POM_NAME) && (requireConfig == null || requireConfig.getModuleInfo() != null && requireConfig.getModuleInfo().getVersion() == null) && (matcher = POM_PATTERN.matcher(name)).matches()) {
                        try {
                            bowerVersion = RequireJsGenerator.getWebjarVersionFromPom((InputStream)jarInputStream);
                            if (requireConfig == null || requireConfig.getModuleInfo() == null || requireConfig.getModuleInfo().getVersion() != null) continue;
                            requireConfig.getModuleInfo().setVersion(bowerVersion);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                try {
                    jarOutputStream.putNextEntry(entry);
                    IOUtils.copy((InputStream)jarInputStream, (OutputStream)jarOutputStream);
                    jarOutputStream.closeEntry();
                }
                catch (IOException ioexception) {
                    this.logger.debug(DEBUG_MESSAGE_FAILED_WRITING, (Throwable)ioexception);
                    this.logger.debug("Closing JarInputStream.");
                    try {
                        jarInputStream.close();
                    }
                    catch (IOException ioexception2) {
                        this.logger.debug("Tried to close JarInputStream, but it was already closed.", (Throwable)ioexception2);
                    }
                    return;
                }
                if (physicalPathNamePart != null || !(matcher = PACKAGE_FILES_PATTERN.matcher(name)).matches()) continue;
                physicalPathNamePart = matcher.group(1);
                physicalPathVersionPart = matcher.group(2);
            }
            if (requireConfig == null) {
                requireConfig = RequireJsGenerator.emptyGenerator(physicalPathNamePart, physicalPathVersionPart);
                this.logger.warn("malformed webjar " + url.toString() + " deployed using root path mapping");
            }
            if (requireConfig != null) {
                try {
                    String exports = !isAmdPackage && !exportedGlobals.isEmpty() ? exportedGlobals.get(0) : null;
                    RequireJsGenerator.ModuleInfo moduleInfo = requireConfig.getConvertedConfig(artifactInfo, isAmdPackage, exports);
                    this.addRequireJsToJar(moduleInfo.exportRequireJs(), jarOutputStream);
                    ZipEntry newEntry = new ZipEntry("OSGI-INF/blueprint/blueprint.xml");
                    String blueprintTemplate = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/org/pentaho/osgi/platform/webjars/blueprint-template.xml"));
                    blueprintTemplate = blueprintTemplate.replaceAll("\\{path\\}", "META-INF/resources/webjars/" + physicalPathNamePart + "/" + physicalPathVersionPart);
                    blueprintTemplate = blueprintTemplate.replace("{versioned_name}", moduleInfo.getVersionedPath());
                    jarOutputStream.putNextEntry(newEntry);
                    jarOutputStream.write(blueprintTemplate.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    this.logger.error("error saving META-INF/js/require.json - " + e.getMessage());
                }
            }
            try {
                jarOutputStream.closeEntry();
                pipedOutputStream.flush();
                jarOutputStream.close();
            }
            catch (IOException ioexception) {
                this.logger.debug(DEBUG_MESSAGE_FAILED_WRITING, (Throwable)ioexception);
                this.logger.debug("Closing JarInputStream.");
                try {
                    jarInputStream.close();
                }
                catch (IOException ioexception3) {
                    this.logger.debug("Tried to close JarInputStream, but it was already closed.", (Throwable)ioexception3);
                }
                return;
            }
        }
        finally {
            this.logger.debug("Closing JarInputStream.");
            try {
                jarInputStream.close();
            }
            catch (IOException ioexception) {
                this.logger.debug("Tried to close JarInputStream, but it was already closed.", (Throwable)ioexception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findAmdDefine(URL url, ArrayList<String> exports) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        InputStream inputStream = urlConnection.getInputStream();
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        try {
            JarEntry entry;
            while ((entry = jarInputStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                Matcher matcher = PACKAGE_JS_FILES_PATTERN.matcher(name);
                if (!matcher.matches() || !this.findAmdDefine(jarInputStream, exports)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.logger.debug("Closing JarInputStream.");
            try {
                jarInputStream.close();
            }
            catch (IOException ioexception) {
                this.logger.debug("Tried to close JarInputStream, but it was already closed.", (Throwable)ioexception);
            }
        }
    }

    private boolean findAmdDefine(InputStream is, ArrayList<String> exports) {
        Pattern definePattern = Pattern.compile("\bdefine\b(\\s*)\\(((\\s*)\"[^\"]+\"(\\s*),)?((\\s*)\\[((\\s*)\"[^\"]+\"(\\s*),?)+(\\s*)\\](\\s*),)?((\\s*)function)");
        Pattern globalPattern = Pattern.compile("(\\bwindow\\b|\\bexports\\b)\\.(([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*)\\s*=\\s*[\\w${][^,;]+");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String var;
                String varSegment;
                Matcher matcher = definePattern.matcher(line);
                if (matcher.find()) {
                    return true;
                }
                matcher = globalPattern.matcher(line);
                if (!matcher.find() || (varSegment = (var = matcher.group(2)).split("\\.", 2)[0]).startsWith("on") || JS_KNOWN_GLOBALS.contains(varSegment) || exports.contains(var)) continue;
                exports.add(var);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private Manifest getManifest(RequireJsGenerator.ArtifactInfo artifactInfo, JarInputStream jarInputStream) {
        Manifest manifest = jarInputStream.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        manifest.getMainAttributes().put(new Attributes.Name("Bundle-SymbolicName"), "pentaho-webjars-" + artifactInfo.getArtifactId());
        manifest.getMainAttributes().put(new Attributes.Name("Import-Package"), "org.osgi.service.http,org.apache.felix.http.api,org.ops4j.pax.web.extender.whiteboard.runtime,org.ops4j.pax.web.extender.whiteboard");
        manifest.getMainAttributes().put(new Attributes.Name("Bundle-Version"), artifactInfo.getOsgiCompatibleVersion());
        return manifest;
    }

    private void addRequireJsToJar(String config, JarOutputStream jarOutputStream) throws IOException {
        ZipEntry newEntry = new ZipEntry(PENTAHO_RJS_LOCATION);
        jarOutputStream.putNextEntry(newEntry);
        jarOutputStream.write(config.getBytes("UTF-8"));
        jarOutputStream.closeEntry();
    }

    static {
        JS_KNOWN_GLOBALS.add("applicationCache");
        JS_KNOWN_GLOBALS.add("caches");
        JS_KNOWN_GLOBALS.add("closed");
        JS_KNOWN_GLOBALS.add("Components");
        JS_KNOWN_GLOBALS.add("console");
        JS_KNOWN_GLOBALS.add("content");
        JS_KNOWN_GLOBALS.add("_content");
        JS_KNOWN_GLOBALS.add("controllers");
        JS_KNOWN_GLOBALS.add("crypto");
        JS_KNOWN_GLOBALS.add("defaultStatus");
        JS_KNOWN_GLOBALS.add("devicePixelRatio");
        JS_KNOWN_GLOBALS.add("dialogArguments");
        JS_KNOWN_GLOBALS.add("directories");
        JS_KNOWN_GLOBALS.add("document");
        JS_KNOWN_GLOBALS.add("frameElement");
        JS_KNOWN_GLOBALS.add("frames");
        JS_KNOWN_GLOBALS.add("fullScreen");
        JS_KNOWN_GLOBALS.add("globalStorage");
        JS_KNOWN_GLOBALS.add("history");
        JS_KNOWN_GLOBALS.add("innerHeight");
        JS_KNOWN_GLOBALS.add("innerWidth");
        JS_KNOWN_GLOBALS.add("length");
        JS_KNOWN_GLOBALS.add("location");
        JS_KNOWN_GLOBALS.add("locationbar");
        JS_KNOWN_GLOBALS.add("localStorage");
        JS_KNOWN_GLOBALS.add("menubar");
        JS_KNOWN_GLOBALS.add("messageManager");
        JS_KNOWN_GLOBALS.add("name");
        JS_KNOWN_GLOBALS.add("navigator");
        JS_KNOWN_GLOBALS.add("opener");
        JS_KNOWN_GLOBALS.add("outerHeight");
        JS_KNOWN_GLOBALS.add("outerWidth");
        JS_KNOWN_GLOBALS.add("pageXOffset");
        JS_KNOWN_GLOBALS.add("pageYOffset");
        JS_KNOWN_GLOBALS.add("sessionStorage");
        JS_KNOWN_GLOBALS.add("parent");
        JS_KNOWN_GLOBALS.add("performance");
        JS_KNOWN_GLOBALS.add("personalbar");
        JS_KNOWN_GLOBALS.add("pkcs11");
        JS_KNOWN_GLOBALS.add("returnValue");
        JS_KNOWN_GLOBALS.add("screen");
        JS_KNOWN_GLOBALS.add("screenX");
        JS_KNOWN_GLOBALS.add("screenY");
        JS_KNOWN_GLOBALS.add("scrollbars");
        JS_KNOWN_GLOBALS.add("scrollMaxX");
        JS_KNOWN_GLOBALS.add("scrollMaxY");
        JS_KNOWN_GLOBALS.add("scrollX");
        JS_KNOWN_GLOBALS.add("scrollY");
        JS_KNOWN_GLOBALS.add("self");
        JS_KNOWN_GLOBALS.add("sessionStorage");
        JS_KNOWN_GLOBALS.add("sidebar");
        JS_KNOWN_GLOBALS.add("status");
        JS_KNOWN_GLOBALS.add("statusbar");
        JS_KNOWN_GLOBALS.add("toolbar");
        JS_KNOWN_GLOBALS.add("top");
        JS_KNOWN_GLOBALS.add("window");
    }
}

