/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.csv;

import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.csv.CSVWriter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;

public class CSVProcessor
extends AbstractReportProcessor {
    protected static final int MAX_EVENTS_PER_RUN = 200;
    protected static final int MIN_ROWS_PER_EVENT = 200;
    public static final String CSV_SEPARATOR = "org.pentaho.reporting.engine.classic.core.modules.output.csv.Separator";
    public static final String CSV_ENCODING = "org.pentaho.reporting.engine.classic.core.modules.output.csv.Encoding";
    public static final String CSV_DATAROWNAME = "org.pentaho.reporting.engine.classic.core.modules.output.csv.WriteDatarowNames";
    public static final String CSV_WRITE_STATECOLUMNS = "org.pentaho.reporting.engine.classic.core.modules.output.csv.WriteStateColumns";
    public static final String CSV_ENABLE_REPORTHEADER = "org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableReportHeader";
    public static final String CSV_ENABLE_REPORTFOOTER = "org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableReportFooter";
    public static final String CSV_ENABLE_GROUPHEADERS = "org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableGroupHeaders";
    public static final String CSV_ENABLE_GROUPFOOTERS = "org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableGroupFooters";
    public static final String CSV_ENABLE_ITEMBANDS = "org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableItembands";
    private Writer writer;
    private static final String EXPORT_DESCRIPTOR = "data/csv";
    private String separator;
    private boolean writeDataRowNames;

    public CSVProcessor(MasterReport report) throws ReportProcessingException {
        this(report, report.getReportConfiguration().getConfigProperty(CSV_SEPARATOR, ","));
    }

    public CSVProcessor(MasterReport report, String separator) throws ReportProcessingException {
        this(report, separator, CSVProcessor.queryBoolConfig((Configuration)report.getReportConfiguration(), CSV_DATAROWNAME));
    }

    public CSVProcessor(MasterReport report, String separator, boolean writeDataRowNames) throws ReportProcessingException {
        super(report, new CSVDataOutputProcessor());
        this.separator = separator;
        this.writeDataRowNames = writeDataRowNames;
    }

    private static boolean queryBoolConfig(Configuration config, String name) {
        return "true".equals(config.getConfigProperty(name, "false"));
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    protected OutputFunction createLayoutManager() {
        CSVWriter lm = new CSVWriter();
        lm.setSeparator(this.separator);
        lm.setWriteDataRowNames(this.writeDataRowNames);
        lm.setWriter(this.getWriter());
        ModifiableConfiguration config = this.getReport().getReportConfiguration();
        lm.setWriteStateColumns(CSVProcessor.queryBoolConfig((Configuration)config, CSV_WRITE_STATECOLUMNS));
        lm.setEnableReportHeader(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_REPORTHEADER));
        lm.setEnableReportFooter(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_REPORTFOOTER));
        lm.setEnableGroupHeader(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_GROUPHEADERS));
        lm.setEnableGroupFooter(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_GROUPFOOTERS));
        lm.setEnableItemband(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_ITEMBANDS));
        return lm;
    }

    protected static boolean isStrictErrorHandling(Configuration config) {
        String strictError = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.StrictErrorHandling");
        return "true".equals(strictError);
    }

    private static class CSVDataOutputProcessor
    extends AbstractOutputProcessor {
        private OutputProcessorMetaData metaData = new GenericOutputProcessorMetaData("data/csv");

        private CSVDataOutputProcessor() {
        }

        @Override
        protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
        }

        @Override
        public OutputProcessorMetaData getMetaData() {
            return this.metaData;
        }
    }
}

