/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;

public class BundleWriterState {
    private MasterReport masterReport;
    private DocumentBundle globalBundle;
    private BundleWriter bundleWriter;
    private AbstractReportDefinition report;
    private String bundleFileName;

    public BundleWriterState(MasterReport masterReport, DocumentBundle globalBundle, BundleWriter writer) {
        if (masterReport == null) {
            throw new NullPointerException();
        }
        if (globalBundle == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        this.report = masterReport;
        this.masterReport = masterReport;
        this.globalBundle = globalBundle;
        this.bundleWriter = writer;
        this.bundleFileName = "";
    }

    public BundleWriterState(BundleWriterState parent, String bundleFileName) {
        this(parent, parent.getReport(), bundleFileName);
    }

    public BundleWriterState(BundleWriterState parent, AbstractReportDefinition report, String bundleFileName) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (bundleFileName == null) {
            throw new NullPointerException();
        }
        this.masterReport = parent.masterReport;
        this.globalBundle = parent.globalBundle;
        this.bundleWriter = parent.bundleWriter;
        this.report = report;
        this.bundleFileName = IOUtils.getInstance().getAbsolutePath(bundleFileName, parent.getFileName());
    }

    public MasterReport getMasterReport() {
        return this.masterReport;
    }

    public DocumentBundle getGlobalBundle() {
        return this.globalBundle;
    }

    public AbstractReportDefinition getReport() {
        return this.report;
    }

    public String getFileName() {
        return this.bundleFileName;
    }

    public BundleWriter getBundleWriter() {
        return this.bundleWriter;
    }
}

