/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.states.process.ReportDoneHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ReportHeaderHandler;

public class BeginReportHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new BeginReportHandler();

    private BeginReportHandler() {
    }

    @Override
    public int getEventCode() {
        return 1;
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        if (!state.getFlowController().getMasterRow().getExpressionDataRow().isValid()) {
            throw new IllegalStateException("The expression data-row must be valid upon the start of the report processing.");
        }
        ProcessState next = state.deriveForAdvance();
        next.fireReportEvent();
        if (next.isSubReportEvent() && next.getLevel() == -2) {
            next.firePageStartedEvent(0x8000001);
        }
        return next;
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        if (next.isSubReportExecutable()) {
            next.setAdvanceHandler(ReportHeaderHandler.HANDLER);
        } else {
            next.setAdvanceHandler(ReportDoneHandler.HANDLER);
        }
        return next;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

