/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.ObjectId;
import org.w3c.dom.Node;

public class JobHopMeta
implements Cloneable,
XMLInterface {
    private static final String XML_TAG = "hop";
    private static Class<?> PKG = JobHopMeta.class;
    private JobEntryCopy from_entry;
    private JobEntryCopy to_entry;
    private boolean enabled;
    public boolean split = false;
    private boolean evaluation;
    private boolean unconditional;
    private boolean changed;
    private ObjectId id;

    public JobHopMeta() {
        this((JobEntryCopy)null, (JobEntryCopy)null);
    }

    public JobHopMeta(JobEntryCopy from, JobEntryCopy to) {
        this.from_entry = from;
        this.to_entry = to;
        this.enabled = true;
        this.split = false;
        this.evaluation = true;
        this.unconditional = false;
        this.id = null;
        if (from != null && from.isStart()) {
            this.setUnconditional();
        }
    }

    public JobHopMeta(Node hopnode, JobMeta job) throws KettleXMLException {
        try {
            String from_name = XMLHandler.getTagValue((Node)hopnode, (String)"from");
            String to_name = XMLHandler.getTagValue((Node)hopnode, (String)"to");
            String sfrom_nr = XMLHandler.getTagValue((Node)hopnode, (String)"from_nr");
            String sto_nr = XMLHandler.getTagValue((Node)hopnode, (String)"to_nr");
            String senabled = XMLHandler.getTagValue((Node)hopnode, (String)"enabled");
            String sevaluation = XMLHandler.getTagValue((Node)hopnode, (String)"evaluation");
            String sunconditional = XMLHandler.getTagValue((Node)hopnode, (String)"unconditional");
            int from_nr = Const.toInt((String)sfrom_nr, (int)0);
            int to_nr = Const.toInt((String)sto_nr, (int)0);
            this.from_entry = job.findJobEntry(from_name, from_nr, true);
            this.to_entry = job.findJobEntry(to_name, to_nr, true);
            this.enabled = senabled == null ? true : "Y".equalsIgnoreCase(senabled);
            this.evaluation = sevaluation == null ? true : "Y".equalsIgnoreCase(sevaluation);
            this.unconditional = "Y".equalsIgnoreCase(sunconditional);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobHopMeta.Exception.UnableToLoadHopInfoXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        if (null != this.from_entry && null != this.to_entry) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
            retval.append("      ").append(XMLHandler.addTagValue((String)"from", (String)this.from_entry.getName()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"to", (String)this.to_entry.getName()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"from_nr", (int)this.from_entry.getNr()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"to_nr", (int)this.to_entry.getNr()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"enabled", (boolean)this.enabled));
            retval.append("      ").append(XMLHandler.addTagValue((String)"evaluation", (boolean)this.evaluation));
            retval.append("      ").append(XMLHandler.addTagValue((String)"unconditional", (boolean)this.unconditional));
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        }
        return retval.toString();
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setEnabled(boolean en) {
        if (this.enabled != en) {
            this.setChanged();
        }
        this.enabled = en;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation() {
        if (!this.evaluation) {
            this.setChanged();
        }
        this.setEvaluation(true);
    }

    public void setEvaluation(boolean e) {
        if (this.evaluation != e) {
            this.setChanged();
        }
        this.evaluation = e;
    }

    public void setUnconditional() {
        if (!this.unconditional) {
            this.setChanged();
        }
        this.unconditional = true;
    }

    public void setConditional() {
        if (this.unconditional) {
            this.setChanged();
        }
        this.unconditional = false;
    }

    public boolean isUnconditional() {
        return this.unconditional;
    }

    public void setSplit(boolean split) {
        if (this.split != split) {
            this.setChanged();
        }
        this.split = split;
    }

    public boolean isSplit() {
        return this.split;
    }

    public String getDescription() {
        if (this.isUnconditional()) {
            return BaseMessages.getString(PKG, (String)"JobHopMeta.Msg.ExecNextJobEntryUncondition", (String[])new String[0]);
        }
        if (this.getEvaluation()) {
            return BaseMessages.getString(PKG, (String)"JobHopMeta.Msg.ExecNextJobEntryFlawLess", (String[])new String[0]);
        }
        return BaseMessages.getString(PKG, (String)"JobHopMeta.Msg.ExecNextJobEntryFailed", (String[])new String[0]);
    }

    public String toString() {
        return this.getDescription();
    }

    public JobEntryCopy getFromEntry() {
        return this.from_entry;
    }

    public void setFromEntry(JobEntryCopy fromEntry) {
        this.from_entry = fromEntry;
        this.changed = true;
    }

    public JobEntryCopy getToEntry() {
        return this.to_entry;
    }

    public void setToEntry(JobEntryCopy toEntry) {
        this.to_entry = toEntry;
        this.changed = true;
    }

    public void setUnconditional(boolean unconditional) {
        if (this.unconditional != unconditional) {
            this.setChanged();
        }
        this.unconditional = unconditional;
    }
}

