/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.joinrows;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.joinrows.JoinRowsData;
import org.pentaho.di.trans.steps.joinrows.JoinRowsMeta;

public class JoinRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = JoinRowsMeta.class;
    private JoinRowsMeta meta;
    private JoinRowsData data;

    public JoinRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public void initialize() throws KettleException {
        this.openRemoteInputStepSocketsOnce();
        try {
            int i;
            this.data.caching = true;
            this.data.filenr = 1;
            for (i = 0; i < this.getInputRowSets().size(); ++i) {
                RowSet rs = this.getInputRowSets().get(i);
                if (!rs.getOriginStepName().equalsIgnoreCase(this.meta.getMainStepname())) continue;
                RowSet zero = this.getInputRowSets().get(0);
                this.getInputRowSets().set(0, rs);
                this.getInputRowSets().set(i, zero);
            }
            this.data.file = new File[this.getInputRowSets().size()];
            this.data.fileInputStream = new FileInputStream[this.getInputRowSets().size()];
            this.data.dataInputStream = new DataInputStream[this.getInputRowSets().size()];
            this.data.size = new int[this.getInputRowSets().size()];
            this.data.fileRowMeta = new RowMetaInterface[this.getInputRowSets().size()];
            this.data.joinrow = new Object[this.getInputRowSets().size()][];
            this.data.rs = new RowSet[this.getInputRowSets().size()];
            this.data.cache = new List[this.getInputRowSets().size()];
            this.data.position = new int[this.getInputRowSets().size()];
            this.data.fileOutputStream = new FileOutputStream[this.getInputRowSets().size()];
            this.data.dataOutputStream = new DataOutputStream[this.getInputRowSets().size()];
            this.data.restart = new boolean[this.getInputRowSets().size()];
            for (i = 1; i < this.getInputRowSets().size(); ++i) {
                String directoryName = this.environmentSubstitute(this.meta.getDirectory());
                this.data.file[i] = File.createTempFile(this.meta.getPrefix(), ".tmp", new File(directoryName));
                this.data.size[i] = 0;
                this.data.rs[i] = this.getInputRowSets().get(i);
                this.data.cache[i] = null;
                this.data.position[i] = 0;
                this.data.dataInputStream[i] = null;
                this.data.dataOutputStream[i] = null;
                this.data.joinrow[i] = null;
                this.data.restart[i] = false;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JoinRows.Log.ErrorCreatingTemporaryFiles", (String[])new String[0]), (Throwable)e);
        }
    }

    public Object[] getRowData(int filenr) throws KettleException {
        this.data.restart[filenr] = false;
        Object[] rowData = null;
        if (filenr == 0) {
            RowSet rowSet = this.getInputRowSets().get(0);
            rowData = this.getRowFrom(rowSet);
            if (rowData != null) {
                this.data.fileRowMeta[0] = rowSet.getRowMeta();
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"JoinRows.Log.ReadRowFromStream", (String[])new String[0]) + (rowData == null ? "<null>" : rowData.toString()));
            }
        } else if (this.data.cache[filenr] == null) {
            if (this.data.dataInputStream[filenr] == null) {
                try {
                    this.data.fileInputStream[filenr] = new FileInputStream(this.data.file[filenr]);
                    this.data.dataInputStream[filenr] = new DataInputStream(this.data.fileInputStream[filenr]);
                }
                catch (FileNotFoundException fnfe) {
                    this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToFindOrOpenTemporaryFile", (String[])new String[0]) + this.data.file[filenr] + "] : " + fnfe.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            if (this.data.size[filenr] == 0) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JoinRows.Log.NoRowsComingFromStep", (String[])new String[0]) + this.data.rs[filenr].getOriginStepName() + "]");
                }
                return null;
            }
            try {
                rowData = this.data.fileRowMeta[filenr].readData(this.data.dataInputStream[filenr]);
            }
            catch (KettleFileException e) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToReadDataFromTempFile", (String[])new String[0]) + filenr + " [" + this.data.file[filenr] + "]");
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            catch (SocketTimeoutException e) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToReadDataFromTempFile", (String[])new String[0]) + filenr + " [" + this.data.file[filenr] + "]");
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"JoinRows.Log.ReadRowFromFile", (String[])new String[0]) + filenr + " : " + this.getInputRowMeta().getString(rowData));
            }
            int n = filenr;
            this.data.position[n] = this.data.position[n] + 1;
            if (this.data.position[filenr] >= this.data.size[filenr]) {
                try {
                    this.data.dataInputStream[filenr].close();
                    this.data.fileInputStream[filenr].close();
                    this.data.dataInputStream[filenr] = null;
                    this.data.fileInputStream[filenr] = null;
                    this.data.position[filenr] = 0;
                    this.data.restart[filenr] = true;
                }
                catch (IOException ioe) {
                    this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToCloseInputStream", (String[])new String[0]) + this.data.file[filenr] + "] : " + ioe.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
        } else {
            if (this.data.size[filenr] == 0) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JoinRows.Log.NoRowsComingFromStep", (String[])new String[0]) + this.data.rs[filenr].getOriginStepName() + "]");
                }
                return null;
            }
            rowData = this.data.cache[filenr].get(this.data.position[this.data.filenr]);
            rowData = this.data.fileRowMeta[filenr].cloneRow(rowData);
            int n = filenr;
            this.data.position[n] = this.data.position[n] + 1;
            if (this.data.position[filenr] >= this.data.size[filenr]) {
                this.data.position[filenr] = 0;
                this.data.restart[filenr] = true;
            }
        }
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (JoinRowsMeta)smi;
        this.data = (JoinRowsData)sdi;
        if (this.first) {
            this.first = false;
            this.initialize();
        }
        return !(this.data.caching ? !this.cacheInputRow() : !this.outputRow());
    }

    private boolean outputRow() throws KettleException {
        this.data.joinrow[this.data.filenr] = this.getRowData(this.data.filenr);
        if (this.data.joinrow[this.data.filenr] == null) {
            while (this.getRow() != null && !this.isStopped()) {
            }
            this.setOutputDone();
            return false;
        }
        if (this.data.filenr >= this.data.file.length - 1) {
            if (this.data.outputRowMeta == null) {
                this.data.outputRowMeta = this.createOutputRowMeta(this.data.fileRowMeta);
            }
            Object[] sum = new Object[this.data.outputRowMeta.size()];
            int sumIndex = 0;
            for (int f = 0; f <= this.data.filenr; ++f) {
                for (int c = 0; c < this.data.fileRowMeta[f].size(); ++c) {
                    sum[sumIndex] = this.data.joinrow[f][c];
                    ++sumIndex;
                }
            }
            if (this.meta.getCondition() != null && !this.meta.getCondition().isEmpty()) {
                if (this.meta.getCondition().evaluate(this.data.outputRowMeta, sum)) {
                    this.putRow(this.data.outputRowMeta, sum);
                }
            } else {
                this.putRow(this.data.outputRowMeta, sum);
            }
            while (this.data.restart[this.data.filenr]) {
                --this.data.filenr;
            }
        } else {
            ++this.data.filenr;
        }
        return true;
    }

    private boolean cacheInputRow() throws KettleException {
        RowSet rowSet;
        Object[] rowData;
        if (this.data.filenr >= this.data.file.length) {
            this.data.caching = false;
            this.data.filenr = 0;
            return true;
        }
        if (this.data.dataOutputStream[this.data.filenr] == null) {
            try {
                this.data.fileOutputStream[this.data.filenr] = new FileOutputStream(this.data.file[this.data.filenr]);
                this.data.dataOutputStream[this.data.filenr] = new DataOutputStream(this.data.fileOutputStream[this.data.filenr]);
            }
            catch (FileNotFoundException fnfe) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToOpenOutputstream", (String[])new String[0]) + this.data.file[this.data.filenr].toString() + "] : " + fnfe.toString());
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
        }
        if ((rowData = this.getRowFrom(rowSet = this.data.rs[this.data.filenr])) != null) {
            if (this.data.fileRowMeta[this.data.filenr] == null) {
                this.data.fileRowMeta[this.data.filenr] = rowSet.getRowMeta().clone();
            }
            this.data.fileRowMeta[this.data.filenr].writeData(this.data.dataOutputStream[this.data.filenr], rowData);
            int n = this.data.filenr;
            this.data.size[n] = this.data.size[n] + 1;
            if (this.log.isRowLevel()) {
                this.logRowlevel(rowData.toString());
            }
            if (this.data.size[this.data.filenr] <= this.meta.getCacheSize()) {
                if (this.data.cache[this.data.filenr] == null) {
                    this.data.cache[this.data.filenr] = new ArrayList<Object[]>();
                }
                this.data.cache[this.data.filenr].add(rowData);
            } else {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JoinRows.Log.RowsFound", (String[])new String[]{this.meta.getCacheSize() + "", this.data.rs[this.data.filenr].getOriginStepName()}));
                }
                this.data.cache[this.data.filenr] = null;
            }
        } else {
            try {
                this.data.dataOutputStream[this.data.filenr].close();
                this.data.fileOutputStream[this.data.filenr].close();
                this.data.dataOutputStream[this.data.filenr] = null;
                this.data.fileOutputStream[this.data.filenr] = null;
            }
            catch (IOException ioe) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.ErrorInClosingOutputStream", (String[])new String[0]) + this.data.filenr + " : [" + this.data.file[this.data.filenr].toString() + "] : " + ioe.toString());
            }
            ++this.data.filenr;
        }
        return true;
    }

    private RowMetaInterface createOutputRowMeta(RowMetaInterface[] fileRowMeta) {
        RowMeta outputRowMeta = new RowMeta();
        for (int i = 0; i < this.data.fileRowMeta.length; ++i) {
            outputRowMeta.mergeRowMeta(this.data.fileRowMeta[i]);
        }
        return outputRowMeta;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JoinRowsMeta)smi;
        this.data = (JoinRowsData)sdi;
        if (this.data.file != null) {
            for (int i = 1; i < this.data.file.length; ++i) {
                this.data.file[i].delete();
            }
        }
        super.dispose(this.meta, this.data);
    }

    @Override
    public void batchComplete() throws KettleException {
        int i;
        RowSet rowSet = this.getInputRowSets().get(0);
        int repeats = 0;
        for (i = 0; i < this.data.cache.length; ++i) {
            if (repeats == 0) {
                repeats = 1;
            }
            if (this.data.cache[i] == null) continue;
            repeats *= this.data.cache[i].size();
        }
        while (rowSet.size() > 0 && !this.isStopped()) {
            this.processRow(this.meta, this.data);
        }
        for (i = 0; i < repeats; ++i) {
            this.processRow(this.meta, this.data);
        }
    }
}

