/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import java.util.Iterator;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

public class SearchEnabledFolderIterator
implements Iterator<Message> {
    private Iterator<Message> iterator;
    private SearchTerm searchTerm;
    private Message next;

    public SearchEnabledFolderIterator(Iterator<Message> messageIterator, SearchTerm search) {
        this.iterator = messageIterator;
        this.searchTerm = search;
        this.fetchNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null && this.searchTerm.match(this.next);
    }

    @Override
    public Message next() {
        Message toReturn = this.next;
        this.fetchNext();
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void fetchNext() {
        while (this.iterator.hasNext()) {
            this.next = this.iterator.next();
            if (this.searchTerm.match(this.next)) {
                return;
            }
            if (this.iterator.hasNext()) continue;
        }
        this.next = null;
    }
}

