/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.util.Date;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SlaveServerJobStatus {
    public static final String XML_TAG = "jobstatus";
    private String jobName;
    private String id;
    private String statusDescription;
    private String errorDescription;
    private String loggingString;
    private int firstLoggingLineNr;
    private int lastLoggingLineNr;
    private Date logDate;
    private Result result;

    public SlaveServerJobStatus() {
    }

    public SlaveServerJobStatus(String transName, String id, String statusDescription) {
        this();
        this.jobName = transName;
        this.id = id;
        this.statusDescription = statusDescription;
    }

    public String getXML() throws KettleException {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("  ").append(XMLHandler.addTagValue((String)"jobname", (String)this.jobName));
        xml.append("  ").append(XMLHandler.addTagValue((String)"id", (String)this.id));
        xml.append("  ").append(XMLHandler.addTagValue((String)"status_desc", (String)this.statusDescription));
        xml.append("  ").append(XMLHandler.addTagValue((String)"error_desc", (String)this.errorDescription));
        xml.append("  ").append(XMLHandler.addTagValue((String)"log_date", (String)XMLHandler.date2string((Date)this.logDate)));
        xml.append("  ").append(XMLHandler.addTagValue((String)"logging_string", (String)XMLHandler.buildCDATA((String)this.loggingString)));
        xml.append("  ").append(XMLHandler.addTagValue((String)"first_log_line_nr", (int)this.firstLoggingLineNr));
        xml.append("  ").append(XMLHandler.addTagValue((String)"last_log_line_nr", (int)this.lastLoggingLineNr));
        if (this.result != null) {
            String resultXML = this.result.getXML();
            xml.append(resultXML);
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public SlaveServerJobStatus(Node jobStatusNode) throws KettleException {
        this();
        Node resultNode;
        this.jobName = XMLHandler.getTagValue((Node)jobStatusNode, (String)"jobname");
        this.id = XMLHandler.getTagValue((Node)jobStatusNode, (String)"id");
        this.statusDescription = XMLHandler.getTagValue((Node)jobStatusNode, (String)"status_desc");
        this.errorDescription = XMLHandler.getTagValue((Node)jobStatusNode, (String)"error_desc");
        this.logDate = XMLHandler.stringToDate((String)XMLHandler.getTagValue((Node)jobStatusNode, (String)"log_date"));
        this.firstLoggingLineNr = Const.toInt((String)XMLHandler.getTagValue((Node)jobStatusNode, (String)"first_log_line_nr"), (int)0);
        this.lastLoggingLineNr = Const.toInt((String)XMLHandler.getTagValue((Node)jobStatusNode, (String)"last_log_line_nr"), (int)0);
        String loggingString64 = XMLHandler.getTagValue((Node)jobStatusNode, (String)"logging_string");
        if (!Utils.isEmpty((CharSequence)loggingString64)) {
            String dataString64 = loggingString64.substring("<![CDATA[".length(), loggingString64.length() - "]]>".length());
            try {
                this.loggingString = HttpUtil.decodeBase64ZippedString((String)dataString64);
            }
            catch (IOException e) {
                this.loggingString = "Unable to decode logging from remote server : " + e.toString() + Const.CR + Const.getStackTracker((Throwable)e);
            }
        } else {
            this.loggingString = "";
        }
        if ((resultNode = XMLHandler.getSubNode((Node)jobStatusNode, (String)"result")) != null) {
            try {
                this.result = new Result(resultNode);
            }
            catch (KettleException e) {
                this.loggingString = this.loggingString + "Unable to serialize result object as XML" + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
            }
        }
    }

    public static SlaveServerJobStatus fromXML(String xml) throws KettleException {
        Document document = XMLHandler.loadXMLString((String)xml);
        SlaveServerJobStatus status = new SlaveServerJobStatus(XMLHandler.getSubNode((Node)document, (String)XML_TAG));
        return status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getLoggingString() {
        return this.loggingString;
    }

    public void setLoggingString(String loggingString) {
        this.loggingString = loggingString;
    }

    public boolean isRunning() {
        return this.getStatusDescription().equalsIgnoreCase("Running") || this.getStatusDescription().equalsIgnoreCase("Initializing");
    }

    public boolean isWaiting() {
        return this.getStatusDescription().equalsIgnoreCase("Waiting");
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public int getFirstLoggingLineNr() {
        return this.firstLoggingLineNr;
    }

    public void setFirstLoggingLineNr(int firstLoggingLineNr) {
        this.firstLoggingLineNr = firstLoggingLineNr;
    }

    public int getLastLoggingLineNr() {
        return this.lastLoggingLineNr;
    }

    public void setLastLoggingLineNr(int lastLoggingLineNr) {
        this.lastLoggingLineNr = lastLoggingLineNr;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

