/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.palo.core;

import com.jedox.palojlib.interfaces.ICell;
import com.jedox.palojlib.interfaces.ICellsExporter;
import com.jedox.palojlib.interfaces.IConnection;
import com.jedox.palojlib.interfaces.IConnectionConfiguration;
import com.jedox.palojlib.interfaces.IConsolidation;
import com.jedox.palojlib.interfaces.ICube;
import com.jedox.palojlib.interfaces.IDatabase;
import com.jedox.palojlib.interfaces.IDimension;
import com.jedox.palojlib.interfaces.IElement;
import com.jedox.palojlib.main.ConnectionConfiguration;
import com.jedox.palojlib.main.ConnectionManager;
import com.jedox.palojlib.main.Consolidation;
import com.jedox.palojlib.main.Database;
import com.jedox.palojlib.managers.LoggerManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Level;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.palo.core.ConsolidationCollection;
import org.pentaho.di.palo.core.ConsolidationElement;
import org.pentaho.di.palo.core.DimensionField;
import org.pentaho.di.palo.core.PaloCubeCache;
import org.pentaho.di.palo.core.PaloDimensionCache;
import org.pentaho.di.palo.core.PaloDimensionLevel;
import org.pentaho.di.palo.core.PaloOption;
import org.pentaho.di.palo.core.PaloOptionCollection;

public class PaloHelper
implements DatabaseFactoryInterface {
    public static boolean connectingToPalo = false;
    private DatabaseMeta databaseMeta;
    private PaloCubeCache cubeCache;
    private PaloDimensionCache dimensionCache;
    private IDatabase database;
    private IConnection connection;
    private final Level paloAPILogLevel;
    private final PaloOptionCollection updateOptions = PaloHelper.getUpdateModeOptions();
    private final PaloOptionCollection splashOptions = PaloHelper.getSplasModeOptions();

    public PaloHelper() {
        this.paloAPILogLevel = Level.OFF;
    }

    public PaloHelper(DatabaseMeta databaseMeta, LogLevel logLevel) {
        this.databaseMeta = databaseMeta;
        switch (logLevel) {
            case NOTHING: {
                this.paloAPILogLevel = Level.OFF;
                break;
            }
            case ERROR: {
                this.paloAPILogLevel = Level.ERROR;
                break;
            }
            case MINIMAL: 
            case BASIC: {
                this.paloAPILogLevel = Level.WARN;
                break;
            }
            case DETAILED: {
                this.paloAPILogLevel = Level.INFO;
                break;
            }
            case DEBUG: {
                this.paloAPILogLevel = Level.DEBUG;
                break;
            }
            case ROWLEVEL: {
                this.paloAPILogLevel = Level.TRACE;
                break;
            }
            default: {
                this.paloAPILogLevel = Level.OFF;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionTestReport(DatabaseMeta databaseMeta) throws KettleDatabaseException {
        StringBuffer report = new StringBuffer();
        PaloHelper helper = new PaloHelper(databaseMeta, LogLevel.ERROR);
        try {
            helper.connect();
            report.append("Connecting to PALO server [").append(databaseMeta.getName()).append("] went without a problem.").append(Const.CR);
        }
        catch (KettleException e) {
            report.append("Unable to connect to the PALO server: ").append(e.getMessage()).append(Const.CR);
            report.append(Const.getStackTracker((Throwable)e));
        }
        finally {
            helper.disconnect();
        }
        return report.toString();
    }

    public final void connect() throws KettleException {
        while (connectingToPalo) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        assert (this.databaseMeta != null);
        try {
            connectingToPalo = true;
            LoggerManager.getInstance().setLevel(this.paloAPILogLevel);
            ConnectionConfiguration connConfig = new ConnectionConfiguration();
            connConfig.setHost(this.databaseMeta.environmentSubstitute(this.databaseMeta.getHostname()));
            connConfig.setPort(this.databaseMeta.environmentSubstitute(this.databaseMeta.getDatabasePortNumberString()));
            connConfig.setUsername(this.databaseMeta.environmentSubstitute(this.databaseMeta.getUsername()));
            connConfig.setPassword(this.databaseMeta.environmentSubstitute(this.databaseMeta.getPassword()));
            connConfig.setTimeout(30000);
            this.connection = ConnectionManager.getInstance().getConnection((IConnectionConfiguration)connConfig);
            this.connection.open();
            this.database = this.connection.getDatabaseByName(this.databaseMeta.environmentSubstitute(this.databaseMeta.getDatabaseName()));
            connectingToPalo = false;
            if (this.database == null) {
                throw new KettleException("The specified database with name '" + this.databaseMeta.environmentSubstitute(this.databaseMeta.getDatabaseName()) + "' could not be found");
            }
        }
        catch (Exception e) {
            connectingToPalo = false;
            throw new KettleException("Unexpected error while connecting to the Palo server: " + e.getMessage(), (Throwable)e);
        }
    }

    public final List<String> getDimensionsNames() {
        assert (this.database != null);
        ArrayList<String> names = new ArrayList<String>();
        for (IDimension dimension : this.database.getDimensions()) {
            if (dimension.getName().startsWith("#")) continue;
            names.add(dimension.getName());
        }
        for (IDimension dimension : this.database.getDimensions()) {
            if (!dimension.getName().startsWith("#")) continue;
            names.add(dimension.getName());
        }
        return names;
    }

    public final List<String> getCubesNames() {
        assert (this.database != null);
        ArrayList<String> names = new ArrayList<String>();
        for (ICube cube : this.database.getCubes()) {
            if (cube.getType() != ICube.CubeType.CUBE_NORMAL) continue;
            names.add(cube.getName());
        }
        for (ICube cube : this.database.getCubes()) {
            if (cube.getType() == ICube.CubeType.CUBE_NORMAL) continue;
            names.add(cube.getName());
        }
        return names;
    }

    public final List<String> getCubeDimensions(String cubeName) {
        assert (this.database != null);
        ArrayList<String> cubeDimensions = new ArrayList<String>();
        ICube cube = this.database.getCubeByName(cubeName);
        IDimension[] dimensions = cube.getDimensions();
        for (int i = 0; i < dimensions.length; ++i) {
            cubeDimensions.add(dimensions[i].getName());
        }
        return cubeDimensions;
    }

    public final RowMetaInterface getCellRowMeta(String cubeName, List<DimensionField> fields, DimensionField cubeMeasure) throws KettleException {
        ICube cube = this.database.getCubeByName(cubeName);
        RowMeta rowMeta = new RowMeta();
        IDimension[] dimensions = cube.getDimensions();
        for (int i = 0; i < dimensions.length; ++i) {
            DimensionField df = null;
            for (DimensionField d : fields) {
                if (!d.getDimensionName().equals(dimensions[i].getName())) continue;
                df = d;
                break;
            }
            if (df == null) {
                throw new KettleException("Dimension " + dimensions[i].getName() + " not found on  fields definition");
            }
            if (df.getFieldType().equals("String")) {
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(df.getFieldName(), 2));
                continue;
            }
            if (df.getFieldType().equals("Number")) {
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(df.getFieldName(), 1));
                continue;
            }
            throw new KettleException("Only String and Number Types are acepted dimension fields");
        }
        if (cubeMeasure == null) {
            throw new KettleException("Measure field not defined.");
        }
        if (cubeMeasure.getFieldType().equals("String")) {
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(cubeMeasure.getFieldName(), 2));
        } else if (cubeMeasure.getFieldType().equals("Number")) {
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(cubeMeasure.getFieldName(), 1));
        } else {
            throw new KettleException("Only String and Number Types are acepted Measure field");
        }
        return rowMeta;
    }

    public final RowMetaInterface getDimensionRowMeta(String dimensionName, List<PaloDimensionLevel> levels, boolean baseElementsOnly) throws KettleException {
        IDimension dimension = this.database.getDimensionByName(dimensionName);
        RowMeta rowMeta = new RowMeta();
        if (baseElementsOnly && levels.size() != 1) {
            throw new KettleException("Base elements should only have one level defined.");
        }
        if (!baseElementsOnly && dimension.getDimensionInfo().getMaximumLevel() + 1 != levels.size()) {
            throw new KettleException("Levels of the dimension differ from defined levels");
        }
        for (int i = 0; i < levels.size(); ++i) {
            String fieldName = levels.get(i).getFieldName();
            if (fieldName == null || fieldName == "") {
                fieldName = dimensionName;
            }
            int type = -1;
            if (levels.get(i).getFieldType().equals("String")) {
                type = 2;
            } else if (levels.get(i).getFieldType().equals("Number")) {
                type = 1;
            } else {
                throw new KettleException("Only String and Number Types are acepted dimension fields");
            }
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(fieldName, type));
        }
        return rowMeta;
    }

    public final List<PaloDimensionLevel> getDimensionLevels(String dimensionName) throws KettleException {
        ArrayList<PaloDimensionLevel> levels = new ArrayList<PaloDimensionLevel>();
        IDimension dimension = this.database.getDimensionByName(dimensionName);
        if (dimension == null) {
            throw new KettleException("Dimension " + dimensionName + " does not exist");
        }
        for (int i = 0; i <= dimension.getDimensionInfo().getMaximumLevel(); ++i) {
            levels.add(new PaloDimensionLevel("Level " + i, i, "", ""));
        }
        return levels;
    }

    public final void getDimensionRows(String dimensionName, RowMetaInterface rowMeta, boolean baseElementsOnly, Listener listener) throws KettleException {
        assert (this.database != null);
        IDimension dimension = this.database.getDimensionByName(dimensionName);
        if (dimension == null) {
            throw new KettleException("Unable to find dimension '" + dimensionName + "' in the Palo database");
        }
        if (baseElementsOnly) {
            for (IElement element : dimension.getElements(false)) {
                if (element.getType() == IElement.ElementType.ELEMENT_CONSOLIDATED) continue;
                Object[] row = new Object[]{element.getName()};
                listener.oneMoreElement(row);
            }
        } else {
            int rowSize = dimension.getDimensionInfo().getMaximumLevel() + 1;
            IElement[] elementsTree = dimension.getRootElements(false);
            Object[] row = new Object[rowSize];
            listener.prepareElements(elementsTree.length);
            for (IElement node : elementsTree) {
                this.assembleDimensionRows(row, rowSize, dimension, node, 0, rowMeta, listener);
            }
        }
    }

    public final void disconnect() {
        assert (this.connection != null);
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public final void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public final IDatabase getDatabase() {
        return this.database;
    }

    public final void setDatabase(Database database) {
        this.database = database;
    }

    public final void manageDimension(String dimensionName, boolean createIfNotExists, boolean clearDimension, boolean clearConsolidations, boolean recreateDimension) throws KettleException {
        IDimension dim = this.database.getDimensionByName(dimensionName);
        if (dim == null) {
            if (createIfNotExists) {
                dim = this.database.addDimension(dimensionName);
            } else {
                throw new KettleException("The dimension " + dimensionName + " does not exist.");
            }
        }
        if (clearConsolidations) {
            ArrayList<IElement> toDeleteArr = new ArrayList<IElement>();
            for (IElement e : dim.getElements(false)) {
                if (e.getType() != IElement.ElementType.ELEMENT_CONSOLIDATED) continue;
                toDeleteArr.add(e);
            }
            if (toDeleteArr.size() > 0) {
                dim.removeElements(toDeleteArr.toArray(new IElement[toDeleteArr.size()]));
            }
        }
        if (recreateDimension) {
            this.database.removeDimension(dim);
            this.database.addDimension(dimensionName);
        }
        if (clearDimension) {
            IElement[] elem = this.database.getDimensionByName(dimensionName).getElements(false);
            this.database.getDimensionByName(dimensionName).removeElements(elem);
        }
    }

    public final void addDimensionElements(ArrayList<String> elements, String elementType) throws Exception {
        IElement.ElementType paloElementType = elementType.equals("Numeric") ? IElement.ElementType.ELEMENT_NUMERIC : IElement.ElementType.ELEMENT_STRING;
        this.dimensionCache.createElements(elements, paloElementType, false);
    }

    public final void addDimensionConsolidations(String dimensionName, ConsolidationCollection consolidationCol) throws Exception {
        this.dimensionCache.getDimension().updateConsolidations((IConsolidation[])this.getConsolidations(this.dimensionCache, consolidationCol));
    }

    public final void removeDimension(String dimensionName) {
        IDimension dim = this.database.getDimensionByName(dimensionName);
        this.database.removeDimension(dim);
    }

    public final int removeCube(String cubeName) {
        ICube cube = this.database.getCubeByName(cubeName);
        if (cube == null) {
            return 0;
        }
        this.database.removeCube(cube);
        return 1;
    }

    public final void createCube(String cubeName, String[] dimensionsNames) {
        ICube cube = this.database.getCubeByName(cubeName);
        if (cube != null) {
            return;
        }
        IDimension[] dims = new IDimension[dimensionsNames.length];
        for (int i = 0; i < dimensionsNames.length; ++i) {
            dims[i] = this.database.getDimensionByName(dimensionsNames[i]);
        }
        this.database.addCube(cubeName, dims);
    }

    public final void clearCube(String cubeName) throws Exception {
        ICube cube = this.database.getCubeByName(cubeName);
        if (cube == null) {
            throw new Exception("The cube " + cubeName + " does not exist.");
        }
        cube.clear();
    }

    public final void addCells(List<Object[]> cells, String addCode, String splashCode) throws Exception {
        if (this.cubeCache == null) {
            throw new Exception("Cube cache hasn't been initialized");
        }
        boolean addValues = (Boolean)this.updateOptions.getValue(addCode);
        ICube.SplashMode splashMode = (ICube.SplashMode)this.splashOptions.getValue(splashCode);
        int dimensionCount = cells.get(0).length - 1;
        IElement[][] dimensionRows = new IElement[cells.size()][dimensionCount];
        Object[] dataRows = new Object[cells.size()];
        ICube cube = this.cubeCache.getCube();
        IDimension[] dimensions = this.cubeCache.getDimensions();
        if (dimensions.length != dimensionCount) {
            throw new Exception("The cube does not have so many dimensions");
        }
        for (int i = 0; i < cells.size(); ++i) {
            String[] elementNames = new String[dimensionCount];
            for (int j = 0; j < dimensionCount; ++j) {
                IElement element = null;
                Object elementNameObj = cells.get(i)[j];
                if (elementNameObj == null) {
                    String row = "";
                    for (int k = 0; k < dimensionCount; ++k) {
                        row = row + "[" + (cells.get(i)[k] == null ? "NULL" : cells.get(i)[k].toString()) + "] ";
                    }
                    throw new Exception("Row: (" + row + ") could not be added since it contains nulls in dimension " + (j + 1) + " (" + dimensions[j].getName() + ")");
                }
                elementNames[j] = elementNameObj.toString();
                element = this.cubeCache.getElement(j, elementNames[j]);
                if (element == null) {
                    throw new Exception("The dimension element " + elementNames[j] + " does not exist in dimension " + dimensions[j].getName());
                }
                dimensionRows[i][j] = element;
            }
            Object dataValue = cells.get(i)[dimensionCount];
            if (!(dataValue instanceof Double) && !(dataValue instanceof String)) {
                throw new Exception("Cell value must be a Double or String to write it to Palo.");
            }
            dataRows[i] = dataValue;
        }
        cube.loadCells(dimensionRows, dataRows, dataRows.length, addValues, splashMode, false);
    }

    public final void getCells(String cubeName, RowMetaInterface rowMeta, Listener listener) throws KettleException {
        ICube cube = this.database.getCubeByName(cubeName);
        IDimension[] cubeDimensions = cube.getDimensions();
        IElement[][] cubeDimensionElements = new IElement[cubeDimensions.length][];
        int[] currentDimensionIndexes = new int[cubeDimensions.length];
        for (int i = 0; i < cubeDimensions.length; ++i) {
            IElement[] elements = cubeDimensions[i].getElements(false);
            ArrayList<IElement> list = new ArrayList<IElement>();
            for (int j = 0; j < elements.length; ++j) {
                list.add(elements[j]);
            }
            cubeDimensionElements[i] = list.toArray(new IElement[list.size()]);
            currentDimensionIndexes[i] = 0;
        }
        ICube.CellsExportType exportType = ICube.CellsExportType.ONLY_NUMERIC;
        if (rowMeta.getValueMeta(cubeDimensions.length).isString()) {
            exportType = ICube.CellsExportType.ONLY_STRING;
        }
        boolean use_rules = false;
        boolean base_only = true;
        boolean skip_empty = true;
        int batchSize = 10000;
        ICellsExporter exporter = cube.getCellsExporter((IElement[][])cubeDimensionElements, exportType, batchSize, use_rules, base_only, skip_empty);
        while (exporter.hasNext()) {
            ICell valueCell = exporter.next();
            Object[] row = new Object[cubeDimensions.length + 1];
            for (int i = 0; i < cubeDimensions.length; ++i) {
                String elementValue = valueCell.getPathNames()[i];
                if (rowMeta.getValueMeta(i).isString()) {
                    row[i] = elementValue;
                    continue;
                }
                if (rowMeta.getValueMeta(i).isNumber()) {
                    row[i] = Double.parseDouble(elementValue);
                    continue;
                }
                throw new KettleException("Only String and Number Types are allowed for dimension values");
            }
            Object data = valueCell.getValue();
            if (rowMeta.getValueMeta(cubeDimensions.length).isString()) {
                if (!(data instanceof String) || !data.toString().equals("")) {
                    row[cubeDimensions.length] = data.toString();
                    listener.oneMoreElement(row);
                }
            } else if (rowMeta.getValueMeta(cubeDimensions.length).isNumber()) {
                if (data instanceof Double) {
                    row[cubeDimensions.length] = data;
                    listener.oneMoreElement(row);
                } else if (!(data instanceof String) || !data.toString().equals("")) {
                    throw new KettleException("Measure field is defined as Number but data from palo is: " + data.getClass().toString());
                }
            } else {
                throw new KettleException("Only String and Number Types are accepted for Measure Field");
            }
            if (listener.getStop()) {
                while (listener.getStop() && !listener.getCancel()) {
                }
            }
            if (!listener.getCancel()) continue;
            break;
        }
    }

    public final void createDatabase(String databaseName) {
        assert (this.database != null);
        this.connection.addDatabase(databaseName);
    }

    private boolean isDimension(String elementName) {
        List<String> dims = this.getDimensionsNames();
        for (String s : dims) {
            if (!s.equals(elementName)) continue;
            return true;
        }
        return false;
    }

    private void showChildren(IElement node, int level) {
        System.out.println("Leido un elemento: " + node.getName() + " level: " + level + " hijo de :" + node.getName());
        System.out.print("TYPE ");
        switch (node.getType()) {
            case ELEMENT_CONSOLIDATED: {
                System.out.println("ELEMENT_CONSOLIDATED");
                break;
            }
            case ELEMENT_NUMERIC: {
                System.out.println("ELEMENT_NUMERIC");
                break;
            }
            case ELEMENT_STRING: {
                System.out.println("ELEMENT_STRING");
            }
        }
        if (this.isDimension(node.getName())) {
            System.out.println(node.getName() + " IS A DIMENSION");
        }
        for (IElement child : node.getChildren()) {
            System.out.println("CONSOLIDATION: CHILD: " + child.getName() + " PARENT: " + node.getName());
        }
        System.out.println("__________________________________________________");
        for (IElement childrenNode : node.getChildren()) {
            this.showChildren(childrenNode, level + 1);
        }
    }

    private void assembleDimensionRows(Object[] currentRow, int rowSize, IDimension dimension, IElement node, int rowIndex, RowMetaInterface rowMeta, Listener listener) throws KettleException {
        switch (node.getType()) {
            case ELEMENT_CONSOLIDATED: 
            case ELEMENT_NUMERIC: 
            case ELEMENT_STRING: {
                if (rowMeta.getValueMeta(rowIndex).isNumber()) {
                    try {
                        currentRow[rowIndex] = Double.parseDouble(node.getName());
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException("Failed to cast Palo Element to Number Type", (Throwable)e);
                    }
                }
                if (rowMeta.getValueMeta(rowIndex).isString()) {
                    currentRow[rowIndex] = node.getName();
                    break;
                }
                throw new KettleException("Invalid Metadata type for dimension level. Must be Number or String");
            }
            default: {
                throw new KettleException("Invalid Dimension Element Palo Type: " + node.getType());
            }
        }
        if (node.getType() == IElement.ElementType.ELEMENT_CONSOLIDATED) {
            int i;
            IElement[] children = node.getChildren();
            for (i = 0; i < children.length; ++i) {
                this.assembleDimensionRows(currentRow, rowSize, dimension, children[i], rowIndex + 1, rowMeta, listener);
            }
            for (i = rowIndex; i < currentRow.length; ++i) {
                currentRow[i] = null;
            }
        } else {
            Object[] clonedRow = new Object[currentRow.length];
            for (int i = 0; i < currentRow.length; ++i) {
                clonedRow[i] = currentRow[i];
            }
            listener.oneMoreElement(clonedRow);
        }
    }

    private Consolidation[] getConsolidations(PaloDimensionCache dimensionCache, ConsolidationCollection consolidationCol) throws KettleException {
        ArrayList consolidations = new ArrayList();
        for (ConsolidationElement element : consolidationCol) {
            try {
                IConsolidation e;
                String parentName = element.getName();
                IElement parentElement = dimensionCache.getElement(parentName);
                Hashtable<String, IConsolidation> newConsolidations = new Hashtable<String, IConsolidation>();
                ArrayList<IConsolidation> sortedNewConsolidations = new ArrayList<IConsolidation>();
                for (IElement child : parentElement.getChildren()) {
                    e = dimensionCache.getDimension().newConsolidation(parentElement, child, child.getWeight(parentElement));
                    newConsolidations.put(child.getName(), e);
                    sortedNewConsolidations.add(e);
                }
                boolean changed = false;
                for (int i = 0; i < element.getChildren().size(); ++i) {
                    String childemename = element.getChildren().get(i).getElement().getName();
                    if (childemename.equals(parentName)) continue;
                    IElement childElement = dimensionCache.getElement(childemename);
                    if (newConsolidations.containsKey(childemename) && ((IConsolidation)newConsolidations.get(childemename)).getWeight() != element.getChildren().get(i).getConsolidationFactor()) {
                        IConsolidation oldConsol = (IConsolidation)newConsolidations.get(childemename);
                        int index = sortedNewConsolidations.indexOf(oldConsol);
                        IConsolidation updatedConsol = dimensionCache.getDimension().newConsolidation(parentElement, childElement, element.getChildren().get(i).getConsolidationFactor());
                        newConsolidations.remove(childemename);
                        newConsolidations.put(childemename, updatedConsol);
                        sortedNewConsolidations.remove(index);
                        sortedNewConsolidations.add(index, updatedConsol);
                        changed = true;
                    }
                    if (newConsolidations.containsKey(childemename)) continue;
                    e = dimensionCache.getDimension().newConsolidation(parentElement, childElement, element.getChildren().get(i).getConsolidationFactor());
                    newConsolidations.put(childemename, e);
                    sortedNewConsolidations.add(e);
                    changed = true;
                }
                if (!changed) continue;
                consolidations.addAll(sortedNewConsolidations);
            }
            catch (Exception e) {
                throw new KettleException("failed to create consolidation: " + element.getName(), (Throwable)e);
            }
        }
        return consolidations.toArray(new Consolidation[0]);
    }

    public void loadCubeCache(String cubeName, boolean enableCache, boolean preloadCache) throws Exception {
        this.cubeCache = new PaloCubeCache(this, cubeName, enableCache);
        if (enableCache && preloadCache) {
            this.cubeCache.loadCubeCache();
        }
    }

    public void clearCubeCache() {
        this.cubeCache = null;
    }

    public void loadDimensionCache(String dimensionName, boolean enableCache, boolean preloadCache) throws Exception {
        this.dimensionCache = new PaloDimensionCache(this.database, dimensionName, enableCache);
        if (this.dimensionCache != null && preloadCache) {
            this.dimensionCache.loadDimensionCache();
        }
    }

    public void clearDimensionCache() {
        this.dimensionCache = null;
    }

    public static PaloOptionCollection getUpdateModeOptions() {
        PaloOptionCollection collection = new PaloOptionCollection();
        collection.add(new PaloOption("SET", false));
        collection.add(new PaloOption("ADD", true));
        return collection;
    }

    public static PaloOptionCollection getSplasModeOptions() {
        PaloOptionCollection collection = new PaloOptionCollection();
        collection.add(new PaloOption("DISABLED", ICube.SplashMode.SPLASH_NOSPLASHING));
        collection.add(new PaloOption("DEFAULT", ICube.SplashMode.SPLASH_DEFAULT));
        collection.add(new PaloOption("ADD", ICube.SplashMode.SPLASH_ADD));
        collection.add(new PaloOption("SET", ICube.SplashMode.SPLASH_SET));
        return collection;
    }

    public static interface Listener {
        public void oneMoreElement(Object var1);

        public void prepareElements(int var1);

        public boolean getStop();

        public void stop();

        public void cancel();

        public void resume();

        public boolean getCancel();
    }
}

