/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import java.util.HashMap;
import org.pentaho.di.baserver.utils.CallEndpointData;
import org.pentaho.di.baserver.utils.CallEndpointMeta;
import org.pentaho.di.baserver.utils.web.HttpConnectionHelper;
import org.pentaho.di.baserver.utils.web.Response;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;

public class CallEndpointStep
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CallEndpointMeta.class;
    private CallEndpointMeta meta;
    private CallEndpointData data;

    public CallEndpointStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CallEndpointMeta)smi;
        this.data = (CallEndpointData)sdi;
        return super.init(smi, sdi);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String httpMethod;
        String endpointPath;
        String moduleName;
        this.meta = (CallEndpointMeta)smi;
        this.data = (CallEndpointData)sdi;
        HttpConnectionHelper connectionHelper = HttpConnectionHelper.getInstance();
        Object[] rowData = this.getRow();
        if (rowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.first = false;
        }
        if (this.meta.isEndpointFromField()) {
            moduleName = this.getRowValue(rowData, this.environmentSubstitute(this.meta.getModuleName()), "");
            endpointPath = this.getRowValue(rowData, this.environmentSubstitute(this.meta.getEndpointPath()), "");
            httpMethod = this.getRowValue(rowData, this.environmentSubstitute(this.meta.getHttpMethod()), "");
        } else {
            moduleName = this.environmentSubstitute(this.meta.getModuleName());
            endpointPath = this.environmentSubstitute(this.meta.getEndpointPath());
            httpMethod = this.environmentSubstitute(this.meta.getHttpMethod());
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (int i = 0; i < this.meta.getFieldName().length; ++i) {
            queryParameters.put(this.meta.getParameter()[i], this.getRowValue(rowData, i));
        }
        Response response = null;
        if (this.meta.isBypassingAuthentication()) {
            try {
                IPentahoSession session = PentahoSessionHolder.getSession();
                if (session != null) {
                    response = connectionHelper.invokeEndpoint(moduleName, endpointPath, httpMethod, queryParameters);
                }
            }
            catch (NoClassDefFoundError ex) {
                this.logBasic("No valid session. Falling back to normal authentication mode.");
            }
        }
        if (response == null) {
            String serverUrl = this.environmentSubstitute(this.meta.getServerURL());
            String username = this.environmentSubstitute(this.meta.getUserName());
            String password = this.environmentSubstitute(this.meta.getPassword());
            response = connectionHelper.invokeEndpoint(serverUrl, username, password, moduleName, endpointPath, httpMethod, queryParameters);
        }
        int index = this.getInputRowMeta().size();
        rowData = RowDataUtil.addValueData((Object[])rowData, (int)index++, (Object)response.getResult());
        rowData = RowDataUtil.addValueData((Object[])rowData, (int)index++, (Object)response.getStatusCode());
        rowData = RowDataUtil.addValueData((Object[])rowData, (int)index, (Object)response.getResponseTime());
        this.putRow(this.data.outputRowMeta, rowData);
        return true;
    }

    protected String getRowValue(Object[] rowData, String fieldName, String defaultValue) throws KettleException {
        int index = this.getInputRowMeta().indexOfValue(fieldName);
        if (index >= 0) {
            ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(index);
            return valueMeta.getCompatibleString(rowData[index]);
        }
        return defaultValue;
    }

    private String getRowValue(Object[] rowData, int i) throws KettleException {
        String fieldName = this.meta.getFieldName()[i];
        if (!Const.isEmpty((String)fieldName)) {
            int index = this.getInputRowMeta().indexOfValue(fieldName);
            if (index >= 0) {
                ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(index);
                Object valueData = rowData[index];
                return valueMeta.getCompatibleString(valueData);
            }
            this.logBasic(BaseMessages.getString(PKG, (String)"CallEndpoint.Log.UnableToFindFieldUsingDefault", (String[])new String[]{fieldName, this.getRowDefaultValue(i)}));
        }
        return this.getRowDefaultValue(i);
    }

    private String getRowDefaultValue(int i) {
        return this.environmentSubstitute(this.meta.getDefaultValue()[i]);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CallEndpointMeta)smi;
        this.data = (CallEndpointData)sdi;
        super.dispose(smi, sdi);
    }
}

