/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.rolap.RolapStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.server.Execution;
import mondrian.spi.Dialect;
import mondrian.spi.StatisticsProvider;

public class RolapStatisticsCache {
    private final RolapStar star;
    private final Map<List, Integer> columnMap = new HashMap<List, Integer>();
    private final Map<List, Integer> tableMap = new HashMap<List, Integer>();
    private final Map<String, Integer> queryMap = new HashMap<String, Integer>();

    public RolapStatisticsCache(RolapStar star) {
        this.star = star;
    }

    public int getRelationCardinality(MondrianDef.Relation relation, String alias, int approxRowCount) {
        if (approxRowCount >= 0) {
            return approxRowCount;
        }
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return this.getTableCardinality(null, table.schema, table.name);
        }
        SqlQuery sqlQuery = this.star.getSqlQuery();
        sqlQuery.addSelect("*", null);
        sqlQuery.addFrom(relation, null, true);
        return this.getQueryCardinality(sqlQuery.toString());
    }

    private int getTableCardinality(String catalog, String schema, String table) {
        List<String> key = Arrays.asList(catalog, schema, table);
        int rowCount = -1;
        if (this.tableMap.containsKey(key)) {
            rowCount = this.tableMap.get(key);
        } else {
            StatisticsProvider statisticsProvider;
            Dialect dialect = this.star.getSqlQueryDialect();
            List<StatisticsProvider> statisticsProviders = dialect.getStatisticsProviders();
            Execution execution = new Execution(this.star.getSchema().getInternalConnection().getInternalStatement(), 0L);
            Iterator<StatisticsProvider> iterator = statisticsProviders.iterator();
            while (iterator.hasNext() && (rowCount = (statisticsProvider = iterator.next()).getTableCardinality(dialect, this.star.getDataSource(), catalog, schema, table, execution)) < 0) {
            }
            this.tableMap.put(key, rowCount);
        }
        return rowCount;
    }

    private int getQueryCardinality(String sql) {
        int rowCount = -1;
        if (this.queryMap.containsKey(sql)) {
            rowCount = this.queryMap.get(sql);
        } else {
            StatisticsProvider statisticsProvider;
            Dialect dialect = this.star.getSqlQueryDialect();
            List<StatisticsProvider> statisticsProviders = dialect.getStatisticsProviders();
            Execution execution = new Execution(this.star.getSchema().getInternalConnection().getInternalStatement(), 0L);
            Iterator<StatisticsProvider> iterator = statisticsProviders.iterator();
            while (iterator.hasNext() && (rowCount = (statisticsProvider = iterator.next()).getQueryCardinality(dialect, this.star.getDataSource(), sql, execution)) < 0) {
            }
            this.queryMap.put(sql, rowCount);
        }
        return rowCount;
    }

    public int getColumnCardinality(MondrianDef.Relation relation, MondrianDef.Expression expression, int approxCardinality) {
        if (approxCardinality >= 0) {
            return approxCardinality;
        }
        if (relation instanceof MondrianDef.Table && expression instanceof MondrianDef.Column) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            MondrianDef.Column column = (MondrianDef.Column)expression;
            return this.getColumnCardinality(null, table.schema, table.name, column.name);
        }
        SqlQuery sqlQuery = this.star.getSqlQuery();
        sqlQuery.setDistinct(true);
        sqlQuery.addSelect(expression.getExpression(sqlQuery), null);
        sqlQuery.addFrom(relation, null, true);
        return this.getQueryCardinality(sqlQuery.toString());
    }

    private int getColumnCardinality(String catalog, String schema, String table, String column) {
        List<String> key = Arrays.asList(catalog, schema, table, column);
        int rowCount = -1;
        if (this.columnMap.containsKey(key)) {
            rowCount = this.columnMap.get(key);
        } else {
            StatisticsProvider statisticsProvider;
            Dialect dialect = this.star.getSqlQueryDialect();
            List<StatisticsProvider> statisticsProviders = dialect.getStatisticsProviders();
            Execution execution = new Execution(this.star.getSchema().getInternalConnection().getInternalStatement(), 0L);
            Iterator<StatisticsProvider> iterator = statisticsProviders.iterator();
            while (iterator.hasNext() && (rowCount = (statisticsProvider = iterator.next()).getColumnCardinality(dialect, this.star.getDataSource(), catalog, schema, table, column, execution)) < 0) {
            }
            this.columnMap.put(key, rowCount);
        }
        return rowCount;
    }

    public int getColumnCardinality2(DataSource dataSource, Dialect dialect, String catalog, String schema, String table, String column) {
        return -1;
    }
}

