/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.dataservice.jdbc.RowsResultSet;
import org.pentaho.di.trans.dataservice.jdbc.ThinBase;
import org.pentaho.di.trans.dataservice.jdbc.ThinConnection;
import org.pentaho.di.trans.dataservice.jdbc.ThinDriver;
import org.pentaho.di.trans.dataservice.jdbc.ThinServiceInformation;
import org.pentaho.di.version.BuildVersion;

public class ThinDatabaseMetaData
extends ThinBase
implements DatabaseMetaData {
    public static final String SCHEMA_NAME_KETTLE = "Kettle";
    private final ThinConnection connection;

    public ThinDatabaseMetaData(ThinConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_CAT", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_SCHEM", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ATTR_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DATA_TYPE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ATTR_TYPE_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ATTR_SIZE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DECIMAL_DIGITS", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("NUM_PREC_RADIX", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("NULLABLE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("REMARKS", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ATTR_DEF", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SQL_DATA_TYPE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SQL_DATETIME_SUB", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("CHAR_OCTET_LENGTH", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ORDINAL_POSITION", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("IS_NULLABLE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SCOPE_CATALOG", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SCOPE_SCHEMA", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SCOPE_TABLE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SOURCE_DATA_TYPE", 5));
        return new RowsResultSet((RowMetaInterface)rowMeta, new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SCOPE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("COLUMN_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DATA_TYPE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("COLUMN_SIZE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("BUFFER_LENGTH", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DECIMAL_DIGITS", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PSEUDO_COLUMN", 5));
        return new RowsResultSet((RowMetaInterface)rowMeta, new ArrayList<Object[]>());
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "Catalog";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_CAT", 2));
        return new RowsResultSet((RowMetaInterface)rowMeta, new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("MAX_LEN", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DEFAULT_VALUE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2));
        return new RowsResultSet((RowMetaInterface)rowMeta, new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getColumnPrivileges(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_CAT", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_SCHEM", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("COLUMN_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("GRANTOR", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("GRANTEE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PRIVILEGE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("IS_GRANTABLE", 2));
        return new RowsResultSet((RowMetaInterface)rowMeta, new ArrayList<Object[]>());
    }

    private List<ThinServiceInformation> getServices(String tableNamePattern) throws Exception {
        ArrayList<ThinServiceInformation> services = new ArrayList();
        if (Const.isEmpty((String)tableNamePattern)) {
            services = this.getServiceInformation();
        } else {
            for (String serviceName : this.getServiceNames(tableNamePattern)) {
                if (!ThinUtil.like(serviceName, tableNamePattern)) continue;
                services.add(this.getServiceInformation(serviceName));
            }
        }
        return services;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ThinDriver.logger.info("getColumns(" + catalog + ", " + schemaPattern + ", " + tableNamePattern + ", " + columnNamePattern + ")");
        try {
            RowMeta rowMeta = new RowMeta();
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_CAT", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_SCHEM", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("COLUMN_NAME", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DATA_TYPE", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_NAME", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("COLUMN_SIZE", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("BUFFER_LENGTH", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DECIMAL_DIGITS", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("NUM_PREC_RADIX", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("NULLABLE", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("REMARKS", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("COLUMN_DEF", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SQL_DATA_TYPE", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SQL_DATATIME_SUB", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("CHAR_OCTET_LENGTH", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ORDINAL_POSITION", 5));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("IS_NULLABLE", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SCOPE_CATALOG", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SCOPE_SCHEMA", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SCOPE_TABLE", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SOURCE_DATA_TYPE", 2));
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            for (ThinServiceInformation service : this.getServices(tableNamePattern)) {
                int ordinal = 1;
                for (ValueMetaInterface valueMeta : service.getServiceFields().getValueMetaList()) {
                    if (Const.isEmpty((String)columnNamePattern) || ThinUtil.like(valueMeta.getName(), columnNamePattern)) {
                        Object[] row = RowDataUtil.allocateRowData((int)rowMeta.size());
                        int index = 0;
                        row[index++] = null;
                        row[index++] = SCHEMA_NAME_KETTLE;
                        row[index++] = service.getName();
                        row[index++] = valueMeta.getName();
                        row[index++] = (long)ThinUtil.getSqlType(valueMeta);
                        row[index++] = ThinUtil.getSqlTypeDesc(valueMeta);
                        row[index++] = (long)valueMeta.getLength();
                        row[index++] = null;
                        row[index++] = (long)valueMeta.getPrecision();
                        row[index++] = 10L;
                        row[index++] = 2;
                        row[index++] = valueMeta.getComments();
                        row[index++] = null;
                        row[index++] = null;
                        row[index++] = null;
                        row[index++] = (long)valueMeta.getLength();
                        row[index++] = (long)ordinal;
                        row[index++] = "";
                        row[index++] = null;
                        row[index++] = null;
                        row[index++] = null;
                        row[index] = valueMeta.getTypeDesc();
                        rows.add(row);
                    }
                    ++ordinal;
                }
            }
            return new RowsResultSet((RowMetaInterface)rowMeta, rows);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_CAT", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_SCHEM", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("COLUMN_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("GRANTOR", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("GRANTEE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PRIVILEGE", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("IS_GRANTABLE", 2));
        return new RowsResultSet((RowMetaInterface)rowMeta, new ArrayList<Object[]>());
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 6;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "PDI";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return BuildVersion.getInstance().getVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 6;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "PDI Data Services JDBC driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "6.0";
    }

    @Override
    public ResultSet getExportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getFunctions(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PKTABLE_CAT", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PKTABLE_SCHEM", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PKTABLE_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PKCOLUMN_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("FKTABLE_CAT", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("FKTABLE_SCHEM", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("FKTABLE_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("FKCOLUMN_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("KEY_SEQ", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("UPDATE_RULE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DELETE_RULE", 5));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("FK_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("PK_NAME", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DEFERRABILITY", 5));
        return new RowsResultSet((RowMetaInterface)rowMeta, new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_OTHER;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "SELECT,FROM,WHERE,GROUP,BY,AS,HAVING,ORDER,AND,OR,IN,NOT,NULL,REGEX,IIF,PARAMETER";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "Schema";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    public List<ThinServiceInformation> getServiceInformation() throws SQLException {
        return this.connection.getClientService().getServiceInformation();
    }

    public ThinServiceInformation getServiceInformation(String name) throws SQLException {
        return this.connection.getClientService().getServiceInformation(name);
    }

    public List<String> getServiceNames(String serviceName) throws SQLException {
        return this.connection.getClientService().getServiceNames(serviceName);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_SCHEM", 2));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_CATALOG", 2));
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (Const.isEmpty((String)schemaPattern) || SCHEMA_NAME_KETTLE.equalsIgnoreCase(schemaPattern)) {
            Object[] row = RowDataUtil.allocateRowData((int)rowMeta.size());
            int index = 0;
            row[index++] = SCHEMA_NAME_KETTLE;
            row[index] = null;
            ThinDriver.logger.info("!!!!!!!-----> reporting one schema: Kettle");
            rows.add(row);
        }
        return new RowsResultSet((RowMetaInterface)rowMeta, rows);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (!Const.isEmpty((String[])types) && Const.indexOfString((String)"TABLE", (String[])types) < 0) {
            ThinDriver.logger.info("-------------> Requesting table types: " + Arrays.toString(types));
            ThinDriver.logger.info("-------------> We only serve up table information, it's all we have!");
            return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
        }
        if (Const.isEmpty((String)tableNamePattern)) {
            ThinDriver.logger.info("-------------> Listing all tables!");
        } else {
            ThinDriver.logger.info("-------------> Looking for table " + tableNamePattern);
        }
        try {
            RowMeta rowMeta = new RowMeta();
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_CAT", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_SCHEM", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_NAME", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TABLE_TYPE", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("REMARKS", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_CAT", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_SCHEM", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("TYPE_NAME", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("SELF_REFERENCING_COL_NAME", 2));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("REF_GENERATION", 2));
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            for (ThinServiceInformation service : this.getServices(tableNamePattern)) {
                Object[] row = RowDataUtil.allocateRowData((int)rowMeta.size());
                int index = 0;
                row[index++] = null;
                row[index++] = SCHEMA_NAME_KETTLE;
                row[index++] = service.getName();
                row[index++] = "TABLE";
                row[index++] = null;
                row[index++] = null;
                row[index++] = null;
                row[index++] = null;
                row[index++] = null;
                row[index] = null;
                rows.add(row);
            }
            ThinDriver.logger.info("-------------> Found " + rows.size() + " tables for the rows resultset.");
            return new RowsResultSet((RowMetaInterface)rowMeta, rows);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUsername();
    }

    @Override
    public ResultSet getVersionColumns(String arg0, String arg1, String arg2) throws SQLException {
        return new RowsResultSet((RowMetaInterface)new RowMeta(), new ArrayList<Object[]>());
    }

    @Override
    public boolean insertsAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int arg0, int arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int arg0, int arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

