/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.event.messaging;

import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.event.message.CoordinatorActionMessage;
import org.apache.oozie.client.event.message.SLAMessage;
import org.apache.oozie.client.event.message.WorkflowJobMessage;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.event.messaging.MessageSerializer;
import org.apache.oozie.service.Services;

public class MessageFactory {
    public static final String OOZIE_MESSAGE_FORMAT = Services.get().getConf().get("message.format", "json");
    public static final String OOZIE_MESSAGE_SERIALIZE = "oozie.jms.serialize.";

    public static MessageSerializer getMessageSerializer() {
        return MessageSerializerHolder.INSTANCE;
    }

    public static WorkflowJobMessage createWorkflowJobMessage(WorkflowJobEvent wfJobEvent) {
        WorkflowJobMessage wfJobMessage = new WorkflowJobMessage(wfJobEvent.getEventStatus(), wfJobEvent.getId(), wfJobEvent.getParentId(), wfJobEvent.getStartTime(), wfJobEvent.getEndTime(), wfJobEvent.getStatus(), wfJobEvent.getUser(), wfJobEvent.getAppName(), wfJobEvent.getErrorCode(), wfJobEvent.getErrorMessage());
        return wfJobMessage;
    }

    public static CoordinatorActionMessage createCoordinatorActionMessage(CoordinatorActionEvent coordActionEvent) {
        CoordinatorActionMessage coordActionMessage = new CoordinatorActionMessage(coordActionEvent.getEventStatus(), coordActionEvent.getId(), coordActionEvent.getParentId(), coordActionEvent.getStartTime(), coordActionEvent.getEndTime(), coordActionEvent.getNominalTime(), coordActionEvent.getStatus(), coordActionEvent.getUser(), coordActionEvent.getAppName(), coordActionEvent.getMissingDeps(), coordActionEvent.getErrorCode(), coordActionEvent.getErrorMessage());
        return coordActionMessage;
    }

    public static SLAMessage createSLAMessage(SLAEvent event) {
        SLAMessage slaMessage = new SLAMessage(event.getEventStatus(), event.getSLAStatus(), event.getAppType(), event.getAppName(), event.getUser(), event.getId(), event.getParentId(), event.getNominalTime(), event.getExpectedStart(), event.getActualStart(), event.getExpectedEnd(), event.getActualEnd(), event.getExpectedDuration(), event.getActualDuration(), event.getNotificationMsg(), event.getUpstreamApps());
        return slaMessage;
    }

    private static class MessageSerializerHolder {
        private static String messageSerializerInstance = Services.get().getConf().get("oozie.jms.serialize." + OOZIE_MESSAGE_FORMAT, "org.apache.oozie.event.messaging.JSONMessageSerializer");
        public static final MessageSerializer INSTANCE;

        private MessageSerializerHolder() {
        }

        static {
            try {
                INSTANCE = (MessageSerializer)ReflectionUtils.newInstance(Class.forName(messageSerializerInstance), null);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Could not construct the serializer ", cnfe);
            }
        }
    }
}

