/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class XmlPluginFileHandler
implements PluginFileHandler {
    private final String xpath;

    protected XmlPluginFileHandler(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public void handle(String relativePath, File file, PluginMetadata pluginMetadata) throws PluginHandlingException {
        FileInputStream fileInputStream = null;
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            NodeList nodeList = (NodeList)xPath.evaluate(this.xpath, inputSource, XPathConstants.NODESET);
            ArrayList<Node> nodes = new ArrayList<Node>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodes.add(nodeList.item(i));
            }
            this.handle(relativePath, nodes, pluginMetadata);
        }
        catch (Exception e) {
            throw new PluginHandlingException(e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract void handle(String var1, List<Node> var2, PluginMetadata var3) throws PluginHandlingException;

    protected Map<String, String> getAttributes(Node node) {
        HashMap<String, String> result = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    protected String camelCaseJoin(String str) {
        StringBuilder sb = new StringBuilder();
        for (String elem : str.split("[^A-Za-z]")) {
            String trimmed = elem.trim();
            if (trimmed.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(trimmed.substring(0, 1).toUpperCase());
            } else {
                sb.append(trimmed.substring(0, 1).toLowerCase());
            }
            if (trimmed.length() <= 1) continue;
            sb.append(trimmed.substring(1));
        }
        return sb.toString();
    }

    protected void setAttribute(Document document, Node node, String attribute, String value) {
        Attr attr = document.createAttribute(attribute);
        attr.setValue(value);
        node.getAttributes().setNamedItem(attr);
    }
}

