/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.osgi.platform.plugin.deployer.api.ManifestUpdater;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.pentaho.osgi.platform.plugin.deployer.impl.ManifestUpdaterImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PluginMetadataImpl
implements PluginMetadata {
    private final ManifestUpdater manifestUpdater = new ManifestUpdaterImpl();
    private Document blueprint;
    private final File rootDirectory;
    private List<String> contentTypes = new ArrayList<String>();

    public PluginMetadataImpl(File rootDirectory) throws ParserConfigurationException {
        this.blueprint = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.blueprint.appendChild(this.blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "blueprint"));
        this.rootDirectory = rootDirectory;
    }

    @Override
    public ManifestUpdater getManifestUpdater() {
        return this.manifestUpdater;
    }

    @Override
    public Document getBlueprint() {
        return this.blueprint;
    }

    @Override
    public void setBlueprint(Document blueprint) {
        this.blueprint = blueprint;
    }

    @Override
    public void writeBlueprint(String name, OutputStream outputStream) throws IOException {
        StreamResult output = new StreamResult(outputStream);
        Document blueprint = this.getBlueprint();
        Element bean = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "bean");
        bean.setAttribute("class", "org.pentaho.platform.pdi.BundleClassloader");
        bean.setAttribute("id", "classLoader");
        Element argument = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "argument");
        argument.setAttribute("ref", "blueprintBundle");
        bean.appendChild(argument);
        argument = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "argument");
        argument.setAttribute("value", this.manifestUpdater.getBundleSymbolicName());
        bean.appendChild(argument);
        blueprint.getDocumentElement().appendChild(bean);
        Element service = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "service");
        service.setAttribute("interface", "java.lang.ClassLoader");
        service.setAttribute("ref", "classLoader");
        Element props = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "service-properties");
        Element entry = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "entry");
        entry.setAttribute("key", "plugin-id");
        entry.setAttribute("value", this.manifestUpdater.getBundleSymbolicName());
        props.appendChild(entry);
        service.appendChild(props);
        blueprint.getDocumentElement().appendChild(service);
        DOMSource input = new DOMSource(blueprint);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public FileWriter getFileWriter(String path) throws IOException {
        File resultFile = this.createFile(path);
        return new FileWriter(resultFile);
    }

    private File createFile(String path) {
        File resultFile = new File(this.rootDirectory.getAbsolutePath() + "/" + path);
        File parentDir = resultFile.getParentFile();
        int tries = 100;
        while (!parentDir.exists() && tries-- > 0) {
            parentDir.mkdirs();
        }
        return resultFile;
    }

    @Override
    public OutputStream getFileOutputStream(String path) throws IOException {
        File resultFile = this.createFile(path);
        return new FileOutputStream(resultFile);
    }

    @Override
    public void addContentType(String contentType) {
        this.contentTypes.add(contentType);
    }

    @Override
    public List<String> getContentTypes() {
        return this.contentTypes;
    }
}

