/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class EmbeddedMetaData
extends MetaData {
    protected String ownerMember;
    protected String nullIndicatorColumn;
    protected String nullIndicatorValue;
    protected DiscriminatorMetaData discriminatorMetaData;
    protected final List members = new ArrayList();
    protected AbstractMemberMetaData[] fieldMetaData;

    public EmbeddedMetaData(EmbeddedMetaData embmd) {
        super(null, embmd);
        this.ownerMember = embmd.ownerMember;
        this.nullIndicatorColumn = embmd.nullIndicatorColumn;
        this.nullIndicatorValue = embmd.nullIndicatorValue;
        for (int i = 0; i < embmd.members.size(); ++i) {
            if (embmd.members.get(i) instanceof FieldMetaData) {
                this.addMember(new FieldMetaData((MetaData)this, (AbstractMemberMetaData)embmd.members.get(i)));
                continue;
            }
            this.addMember(new PropertyMetaData((MetaData)this, (PropertyMetaData)embmd.members.get(i)));
        }
    }

    public EmbeddedMetaData() {
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr) {
        int i;
        Class cls;
        MetaData md = this.getParent();
        AbstractMemberMetaData apmd = null;
        AbstractClassMetaData embCmd = null;
        String embeddedType = null;
        if (md instanceof AbstractMemberMetaData) {
            apmd = (AbstractMemberMetaData)md;
            embeddedType = apmd.getTypeName();
            embCmd = mmgr.getMetaDataForClassInternal(apmd.getType(), clr);
            if (embCmd == null && apmd.getFieldTypes() != null && apmd.getFieldTypes().length == 1) {
                embCmd = mmgr.getMetaDataForClassInternal(clr.classForName(apmd.getFieldTypes()[0]), clr);
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044121", (Object)apmd.getFullFieldName(), (Object)apmd.getTypeName()));
                throw new InvalidMemberMetaDataException(LOCALISER, "044121", apmd.getClassName(), apmd.getName(), (Object)apmd.getTypeName());
            }
        } else if (md instanceof ElementMetaData) {
            ElementMetaData elemmd = (ElementMetaData)md;
            apmd = (AbstractMemberMetaData)elemmd.getParent();
            embeddedType = apmd.getCollection().getElementType();
            try {
                cls = clr.classForName(embeddedType, primary);
                embCmd = mmgr.getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044122", (Object)apmd.getFullFieldName(), (Object)embeddedType));
                throw new InvalidMemberMetaDataException(LOCALISER, "044122", apmd.getClassName(), apmd.getName(), (Object)embeddedType);
            }
        } else if (md instanceof KeyMetaData) {
            KeyMetaData keymd = (KeyMetaData)md;
            apmd = (AbstractMemberMetaData)keymd.getParent();
            embeddedType = apmd.getMap().getKeyType();
            try {
                cls = clr.classForName(embeddedType, primary);
                embCmd = mmgr.getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044123", (Object)apmd.getFullFieldName(), (Object)embeddedType));
                throw new InvalidMemberMetaDataException(LOCALISER, "044123", apmd.getClassName(), apmd.getName(), (Object)embeddedType);
            }
        } else if (md instanceof ValueMetaData) {
            ValueMetaData valuemd = (ValueMetaData)md;
            apmd = (AbstractMemberMetaData)valuemd.getParent();
            embeddedType = apmd.getMap().getValueType();
            try {
                cls = clr.classForName(embeddedType, primary);
                embCmd = mmgr.getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044124", (Object)apmd.getFullFieldName(), (Object)embeddedType));
                throw new InvalidMemberMetaDataException(LOCALISER, "044124", apmd.getClassName(), apmd.getName(), (Object)embeddedType);
            }
        }
        for (Object fld : this.members) {
            if (!(embCmd instanceof InterfaceMetaData) || !(fld instanceof FieldMetaData)) continue;
            throw new InvalidMemberMetaDataException(LOCALISER, "044129", apmd.getClassName(), apmd.getName(), (Object)((AbstractMemberMetaData)fld).getName());
        }
        Class embeddedClass = null;
        Collections.sort(this.members);
        try {
            embeddedClass = clr.classForName(embeddedType, primary);
            Field[] cls_fields = embeddedClass.getDeclaredFields();
            for (i = 0; i < cls_fields.length; ++i) {
                if (!cls_fields[i].getDeclaringClass().getName().equals(embeddedType) || cls_fields[i].getName().startsWith("jdo") || ClassUtils.isInnerClass(cls_fields[i].getName()) || Modifier.isStatic(cls_fields[i].getModifiers()) || Collections.binarySearch(this.members, cls_fields[i].getName()) >= 0) continue;
                AbstractMemberMetaData embMmd = embCmd.getMetaDataForMember(cls_fields[i].getName());
                FieldMetaData omittedFmd = null;
                if (embMmd != null) {
                    FieldPersistenceModifier fieldModifier = embMmd.getPersistenceModifier();
                    if (fieldModifier == FieldPersistenceModifier.DEFAULT) {
                        fieldModifier = embMmd.getDefaultFieldPersistenceModifier(cls_fields[i].getType(), cls_fields[i].getModifiers(), mmgr.isFieldTypePersistable(cls_fields[i].getType()), mmgr);
                    }
                    if (fieldModifier == FieldPersistenceModifier.PERSISTENT) {
                        omittedFmd = new FieldMetaData((MetaData)this, embMmd);
                        omittedFmd.setPrimaryKey(false);
                    }
                } else {
                    omittedFmd = new FieldMetaData((MetaData)this, cls_fields[i].getName());
                }
                if (omittedFmd == null) continue;
                NucleusLogger.METADATA.debug(LOCALISER.msg("044125", (Object)apmd.getClassName(), (Object)cls_fields[i].getName(), (Object)embeddedType));
                this.members.add(omittedFmd);
                Collections.sort(this.members);
            }
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        if (embCmd instanceof InterfaceMetaData) {
            try {
                Method[] clsMethods = embeddedClass.getDeclaredMethods();
                for (i = 0; i < clsMethods.length; ++i) {
                    String fieldName;
                    if (!clsMethods[i].getDeclaringClass().getName().equals(embeddedType) || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || Collections.binarySearch(this.members, fieldName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName())) >= 0) continue;
                    NucleusLogger.METADATA.debug(LOCALISER.msg("044060", (Object)apmd.getClassName(), (Object)fieldName));
                    PropertyMetaData pmd = new PropertyMetaData((MetaData)this, fieldName);
                    this.members.add(pmd);
                    Collections.sort(this.members);
                }
            }
            catch (Exception e) {
                NucleusLogger.METADATA.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
        Collections.sort(this.members);
        Iterator memberIter = this.members.iterator();
        while (memberIter.hasNext()) {
            Class embFmdClass = embeddedClass;
            AbstractMemberMetaData fieldFmd = (AbstractMemberMetaData)memberIter.next();
            if (!fieldFmd.fieldBelongsToClass()) {
                try {
                    embFmdClass = clr.classForName(fieldFmd.getClassName(true));
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClsName = embeddedClass.getPackage().getName() + "." + fieldFmd.getClassName(true);
                    fieldFmd.setClassName(fieldClsName);
                    embFmdClass = clr.classForName(fieldClsName);
                }
            }
            if (fieldFmd instanceof FieldMetaData) {
                Field cls_field = null;
                try {
                    cls_field = embFmdClass.getDeclaredField(fieldFmd.getName());
                }
                catch (Exception e) {
                    throw new InvalidMemberMetaDataException(LOCALISER, "044071", embFmdClass.getName(), fieldFmd.getName());
                }
                fieldFmd.populate(clr, cls_field, null, primary, mmgr);
                continue;
            }
            Method cls_method = null;
            try {
                cls_method = embFmdClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fieldFmd.getName(), true), new Class[0]);
            }
            catch (Exception e) {
                try {
                    cls_method = embFmdClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fieldFmd.getName(), false), new Class[0]);
                }
                catch (Exception e2) {
                    throw new InvalidMemberMetaDataException(LOCALISER, "044071", embFmdClass.getName(), fieldFmd.getName());
                }
            }
            fieldFmd.populate(clr, null, cls_method, primary, mmgr);
        }
    }

    @Override
    public void initialise(ClassLoaderResolver clr, MetaDataManager mmgr) {
        this.fieldMetaData = new AbstractMemberMetaData[this.members.size()];
        for (int i = 0; i < this.fieldMetaData.length; ++i) {
            this.fieldMetaData[i] = (AbstractMemberMetaData)this.members.get(i);
            this.fieldMetaData[i].initialise(clr, mmgr);
        }
        if (this.discriminatorMetaData != null) {
            this.discriminatorMetaData.initialise(clr, mmgr);
        }
        this.setInitialised();
    }

    public final AbstractMemberMetaData[] getMemberMetaData() {
        return this.fieldMetaData;
    }

    public final String getOwnerMember() {
        return this.ownerMember;
    }

    public EmbeddedMetaData setOwnerMember(String ownerMember) {
        this.ownerMember = StringUtils.isWhitespace(ownerMember) ? null : ownerMember;
        return this;
    }

    public final String getNullIndicatorColumn() {
        return this.nullIndicatorColumn;
    }

    public EmbeddedMetaData setNullIndicatorColumn(String column) {
        this.nullIndicatorColumn = StringUtils.isWhitespace(column) ? null : column;
        return this;
    }

    public final String getNullIndicatorValue() {
        return this.nullIndicatorValue;
    }

    public EmbeddedMetaData setNullIndicatorValue(String value) {
        this.nullIndicatorValue = StringUtils.isWhitespace(value) ? null : value;
        return this;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.discriminatorMetaData;
    }

    public EmbeddedMetaData setDiscriminatorMetaData(DiscriminatorMetaData dismd) {
        this.discriminatorMetaData = dismd;
        this.discriminatorMetaData.parent = this;
        return this;
    }

    public DiscriminatorMetaData newDiscriminatorMetadata() {
        DiscriminatorMetaData dismd = new DiscriminatorMetaData();
        this.setDiscriminatorMetaData(dismd);
        return dismd;
    }

    public void addMember(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new InvalidMemberMetaDataException(LOCALISER, "044108", mmd.getClassName(), mmd.getName());
        }
        for (AbstractMemberMetaData md : this.members) {
            if (!mmd.getName().equals(md.getName())) continue;
            throw new InvalidMemberMetaDataException(LOCALISER, "044112", mmd.getClassName(), mmd.getName());
        }
        this.members.add(mmd);
        mmd.parent = this;
    }

    public FieldMetaData newFieldMetaData(String name) {
        FieldMetaData fmd = new FieldMetaData((MetaData)this, name);
        this.addMember(fmd);
        return fmd;
    }

    public PropertyMetaData newPropertyMetaData(String name) {
        PropertyMetaData pmd = new PropertyMetaData((MetaData)this, name);
        this.addMember(pmd);
        return pmd;
    }

    @Override
    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<embedded");
        if (this.ownerMember != null) {
            sb.append(" owner-field=\"" + this.ownerMember + "\"");
        }
        if (this.nullIndicatorColumn != null) {
            sb.append(" null-indicator-column=\"" + this.nullIndicatorColumn + "\"");
        }
        if (this.nullIndicatorValue != null) {
            sb.append(" null-indicator-value=\"" + this.nullIndicatorValue + "\"");
        }
        sb.append(">\n");
        if (this.discriminatorMetaData != null) {
            sb.append(this.discriminatorMetaData.toString(prefix + indent, indent));
        }
        for (int i = 0; i < this.members.size(); ++i) {
            AbstractMemberMetaData f = (AbstractMemberMetaData)this.members.get(i);
            sb.append(f.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</embedded>\n");
        return sb.toString();
    }
}

