/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import org.pentaho.gis.shapefiles.Converter;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeInterface;
import org.pentaho.gis.shapefiles.ShapePoint;

public class ShapePolyLineM
extends Shape
implements ShapeInterface {
    public int nrparts;
    public int nrpoints;
    public int nrmeasures;
    public double box_minx;
    public double box_miny;
    public double box_maxx;
    public double box_maxy;
    public int[] part_starts;
    public ShapePoint[] point;
    public double mmin;
    public double mmax;
    public double[] measures;

    public ShapePolyLineM(byte[] content) {
        super(23);
        int pos;
        int i;
        this.box_minx = Converter.getDoubleLittle(content, 4);
        this.box_miny = Converter.getDoubleLittle(content, 12);
        this.box_maxx = Converter.getDoubleLittle(content, 20);
        this.box_maxy = Converter.getDoubleLittle(content, 28);
        this.nrparts = Converter.getIntegerLittle(content, 36);
        this.nrpoints = Converter.getIntegerLittle(content, 40);
        int pos_parts = 44;
        int pos_points = pos_parts + this.nrparts * 4;
        int pos_mmin = pos_points + 16 * this.nrpoints;
        int pos_mmax = pos_mmin + 8;
        int pos_marray = pos_mmax + 16;
        int tot_length = pos_marray + 8 * this.nrpoints;
        this.part_starts = new int[this.nrparts];
        this.point = new ShapePoint[this.nrpoints];
        this.measures = null;
        for (i = 0; i < this.nrparts; ++i) {
            pos = 44 + i * 4;
            this.part_starts[i] = Converter.getIntegerLittle(content, pos);
        }
        for (i = 0; i < this.nrpoints; ++i) {
            pos = 44 + this.nrparts * 4 + 16 * i;
            double pointx = Converter.getDoubleLittle(content, pos);
            double pointy = Converter.getDoubleLittle(content, pos + 8);
            this.point[i] = new ShapePoint(pointx, pointy);
        }
        if (tot_length == content.length + 8) {
            pos = 44 + this.nrparts * 4 + 16 * this.nrpoints;
            this.mmin = Converter.getDoubleLittle(content, pos);
            this.mmax = Converter.getDoubleLittle(content, pos + 8);
            this.measures = new double[this.nrpoints < 0 ? 0 : this.nrpoints];
            for (i = 0; i < this.nrpoints; ++i) {
                this.measures[i] = Converter.getDoubleLittle(content, pos + 16 + i * 8);
            }
        }
    }

    public boolean contains(ShapePoint p) {
        for (int i = 0; i < this.nrpoints; ++i) {
            if (!p.equals(this.point[i])) continue;
            return true;
        }
        return false;
    }
}

