/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class PercolateSourceBuilder
extends ToXContentToBytes {
    private DocBuilder docBuilder;
    private QueryBuilder queryBuilder;
    private Integer size;
    private List<SortBuilder> sorts;
    private Boolean trackScores;
    private HighlightBuilder highlightBuilder;
    private List<AbstractAggregationBuilder> aggregations;

    public PercolateSourceBuilder setDoc(DocBuilder docBuilder) {
        this.docBuilder = docBuilder;
        return this;
    }

    public PercolateSourceBuilder setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public PercolateSourceBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public PercolateSourceBuilder setSort(boolean sort) {
        if (sort) {
            this.addSort(new ScoreSortBuilder());
        } else {
            this.sorts = null;
        }
        return this;
    }

    public PercolateSourceBuilder addSort(SortBuilder sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<SortBuilder>();
        }
        this.sorts.add(sort);
        return this;
    }

    public PercolateSourceBuilder setTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public PercolateSourceBuilder setHighlightBuilder(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public PercolateSourceBuilder addAggregation(AbstractAggregationBuilder aggregationBuilder) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<AbstractAggregationBuilder>();
        }
        this.aggregations.add(aggregationBuilder);
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.docBuilder != null) {
            this.docBuilder.toXContent(builder, params);
        }
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.size != null) {
            builder.field("size", this.size);
        }
        if (this.sorts != null) {
            builder.startArray("sort");
            for (SortBuilder sort : this.sorts) {
                builder.startObject();
                sort.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.trackScores != null) {
            builder.field("track_scores", (Object)this.trackScores);
        }
        if (this.highlightBuilder != null) {
            this.highlightBuilder.toXContent(builder, params);
        }
        if (this.aggregations != null) {
            builder.field("aggregations");
            builder.startObject();
            for (AbstractAggregationBuilder aggregation : this.aggregations) {
                aggregation.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static DocBuilder docBuilder() {
        return new DocBuilder();
    }

    public static class DocBuilder
    implements ToXContent {
        private BytesReference doc;

        public DocBuilder setDoc(BytesReference doc) {
            this.doc = doc;
            return this;
        }

        public DocBuilder setDoc(String field, Object value) {
            HashMap<String, Object> values = new HashMap<String, Object>(2);
            values.put(field, value);
            this.setDoc(values);
            return this;
        }

        public DocBuilder setDoc(String doc) {
            this.doc = new BytesArray(doc);
            return this;
        }

        public DocBuilder setDoc(XContentBuilder doc) {
            this.doc = doc.bytes();
            return this;
        }

        public DocBuilder setDoc(Map doc) {
            return this.setDoc(doc, Requests.CONTENT_TYPE);
        }

        public DocBuilder setDoc(Map doc, XContentType contentType) {
            try {
                return this.setDoc(XContentFactory.contentBuilder(contentType).map(doc));
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("Failed to generate [" + doc + "]", e);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.rawField("doc", this.doc);
        }
    }
}

