/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class ConstantScoreQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<ConstantScoreQueryBuilder> {
    private final QueryBuilder filterBuilder;
    private float boost = -1.0f;

    public ConstantScoreQueryBuilder(QueryBuilder filterBuilder) {
        this.filterBuilder = Objects.requireNonNull(filterBuilder);
    }

    @Override
    public ConstantScoreQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("constant_score");
        builder.field("filter");
        this.filterBuilder.toXContent(builder, params);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

